/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.sequence;

import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.primitives.S3;
import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.primitives.sequence.RepIntVector;
import org.renjin.primitives.sequence.RepStringVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class RepFunction
extends SpecialFunction {
    public RepFunction() {
        super("rep");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList arguments) {
        SEXP result;
        if (arguments == Null.INSTANCE) {
            context.setInvisibleFlag();
            return Null.INSTANCE;
        }
        ArgumentIterator argIt = new ArgumentIterator(context, rho, arguments);
        PairList.Node firstArgNode = argIt.nextNode();
        SEXP firstArg = context.evaluate(firstArgNode.getValue(), rho);
        if (firstArg.isObject() && (result = S3.tryDispatchFromPrimitive(context, rho, call2, "rep", firstArg, arguments)) != null) {
            return result;
        }
        PairList.Builder evaled = new PairList.Builder();
        evaled.add(firstArgNode.getRawTag(), firstArg);
        while (argIt.hasNext()) {
            PairList.Node node = argIt.nextNode();
            evaled.add(node.getRawTag(), context.evaluate(node.getValue(), rho));
        }
        PairList.Builder formals2 = new PairList.Builder();
        formals2.add("x", (SEXP)Symbol.MISSING_ARG);
        formals2.add("times", (SEXP)Symbol.MISSING_ARG);
        formals2.add("length.out", (SEXP)Symbol.MISSING_ARG);
        formals2.add("each", (SEXP)Symbol.MISSING_ARG);
        formals2.add(Symbols.ELLIPSES, (SEXP)Symbol.MISSING_ARG);
        PairList matched = ClosureDispatcher.matchArguments(formals2.build(), evaled.build(), true);
        SEXP x = matched.findByTag(Symbol.get("x"));
        SEXP times2 = matched.findByTag(Symbol.get("times"));
        SEXP lengthOut = matched.findByTag(Symbol.get("length.out"));
        SEXP each = matched.findByTag(Symbol.get("each"));
        return RepFunction.rep((Vector)x, times2 == Symbol.MISSING_ARG ? new IntArrayVector(1) : (Vector)times2, lengthOut == Symbol.MISSING_ARG ? Integer.MIN_VALUE : ((Vector)lengthOut).getElementAsInt(0), each == Symbol.MISSING_ARG ? Integer.MIN_VALUE : ((Vector)each).getElementAsInt(0));
    }

    public static Vector rep(Vector x, Vector times2, int lengthOut, int each) {
        int resultLength;
        if (x == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        if (x.length() == 0) {
            x = x.getVectorType().newBuilderWithInitialCapacity(1).addNA().build();
        }
        if (times2.length() == 1) {
            resultLength = x.length() * times2.getElementAsInt(0);
        } else {
            resultLength = 0;
            for (int i = 0; i != x.length(); ++i) {
                resultLength += times2.getElementAsInt(i);
            }
        }
        if (!IntVector.isNA(each)) {
            resultLength *= each;
        } else {
            each = 1;
        }
        if (!IntVector.isNA(lengthOut)) {
            if (lengthOut < 0) {
                throw new EvalException("invalid 'length.out' argument", new Object[0]);
            }
            resultLength = lengthOut;
        }
        if (times2.length() > 1 && each > 1) {
            throw new EvalException("invalid 'times' argument", new Object[0]);
        }
        if (x instanceof DoubleVector && times2.length() == 1 && lengthOut != 0 && (x.isDeferred() || resultLength > 100)) {
            return new RepDoubleVector(x, resultLength, each, RepFunction.repeatAttributes(x, resultLength, each));
        }
        if (x instanceof IntVector && times2.length() == 1 && lengthOut != 0 && (x.isDeferred() || resultLength > 100)) {
            return new RepIntVector(x, resultLength, each, RepFunction.repeatAttributes(x, resultLength, each));
        }
        Vector.Builder result = x.newBuilderWithInitialCapacity(resultLength);
        AtomicVector names2 = x.getNames();
        StringVector.Builder resultNames = null;
        if (names2 != Null.INSTANCE) {
            resultNames = new StringVector.Builder(0, resultLength);
        }
        int result_i = 0;
        if (times2.length() == 1) {
            for (int i = 0; i != resultLength; ++i) {
                int x_i = i / each % x.length();
                result.setFrom(result_i++, x, x_i);
                if (resultNames == null) continue;
                resultNames.add(names2.getElementAsString(x_i));
            }
        } else {
            for (int x_i = 0; x_i != x.length(); ++x_i) {
                for (int j = 0; j < times2.getElementAsInt(x_i); ++j) {
                    result.setFrom(result_i++, x, x_i);
                    if (resultNames == null) continue;
                    resultNames.add(names2.getElementAsString(x_i));
                }
            }
        }
        if (resultNames != null) {
            result.setAttribute(Symbols.NAMES, (SEXP)resultNames.build());
        }
        return result.build();
    }

    private static AttributeMap repeatAttributes(Vector source, int length2, int each) {
        AtomicVector names2 = source.getNames();
        if (names2 != Null.INSTANCE) {
            AttributeMap.Builder repeated = AttributeMap.newBuilder();
            repeated.setNames(new RepStringVector(names2, length2, each, AttributeMap.EMPTY));
            return repeated.build();
        }
        return AttributeMap.EMPTY;
    }
}

