/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.print;

import org.renjin.parser.StringLiterals;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.sexp.StringVector;

public class StringPrinter
implements Function<String, String> {
    private char quote = '\u0000';
    private String naString = "NA";
    private int width = -1;

    public StringPrinter setQuotes(boolean quote) {
        this.quote = quote ? (char)34 : (char)'\u0000';
        return this;
    }

    public StringPrinter setNaString(String naString) {
        this.naString = naString;
        return this;
    }

    @Override
    public String apply(String s) {
        StringBuilder sb = new StringBuilder();
        if (StringVector.isNA(s)) {
            return this.naString;
        }
        if (this.quote != '\u0000') {
            sb.append(this.quote);
        }
        StringLiterals.appendEscaped(sb, s);
        if (this.quote != '\u0000') {
            sb.append(this.quote);
        }
        return sb.toString();
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }
}

