/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.io.IOException;
import org.renjin.eval.Context;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Invisible;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.primitives.packaging.NamespaceRegistry;
import org.renjin.sexp.Environment;
import org.renjin.sexp.HashFrame;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;

public class Packages {
    public static final FqPackageName METHODS_NAMESPACE = new FqPackageName("org.renjin", "methods");

    @Internal
    public static void library(@Current Context context, @Current NamespaceRegistry namespaceRegistry, String packageName) throws IOException {
        Namespace namespace = namespaceRegistry.getNamespace(context, packageName);
        if (Packages.isAttached(context, namespace)) {
            return;
        }
        for (String dependencyName : namespace.getPackage().getPackageDependencies()) {
            context.getSession().getStdOut().println("Loading required package: " + dependencyName);
            Packages.library(context, namespaceRegistry, dependencyName);
        }
        Environment packageEnv = context.getGlobalEnvironment().insertAbove(new HashFrame());
        packageEnv.setAttribute(Symbols.NAME, (SEXP)StringVector.valueOf("package:" + namespace.getFullyQualifiedName().getPackageName()));
        packageEnv.setAttribute(Symbols.FQNAME, (SEXP)StringVector.valueOf("package:" + namespace.getFullyQualifiedName().toString()));
        namespace.copyExportsTo(context, packageEnv);
        context.setInvisibleFlag();
    }

    private static boolean isAttached(Context context, Namespace namespace) {
        String expected = "package:" + namespace.getFullyQualifiedName().toString();
        for (Environment env2 = context.getGlobalEnvironment(); env2 != Environment.EMPTY; env2 = env2.getParent()) {
            String fqName;
            SEXP fqNameSexp = env2.getAttribute(Symbols.FQNAME);
            if (!(fqNameSexp instanceof StringVector) || fqNameSexp.length() != 1 || !expected.equals(fqName = ((StringVector)fqNameSexp).getElementAsString(0))) continue;
            return true;
        }
        return false;
    }

    @Internal
    @Invisible
    public static boolean require(@Current Context context, @Current NamespaceRegistry registry, String packageName) {
        try {
            Packages.library(context, registry, packageName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

