/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.packaging.Dataset;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.util.NamedByteSource;

public abstract class Package {
    private final FqPackageName name;

    protected Package(FqPackageName name) {
        this.name = name;
    }

    public final FqPackageName getName() {
        return this.name;
    }

    public Iterable<NamedValue> loadSymbols(Context context) throws IOException {
        return Collections.emptySet();
    }

    public NamedByteSource getResource(String name) throws IOException {
        throw new IOException();
    }

    public List<Dataset> getDatasets() {
        return Collections.emptyList();
    }

    public SEXP getDataset(String datasetName) throws IOException {
        for (Dataset dataset : this.getDatasets()) {
            if (!dataset.getName().equals(datasetName)) continue;
            return dataset.loadAll();
        }
        return Null.INSTANCE;
    }

    public abstract Class loadClass(String var1) throws ClassNotFoundException;

    public Collection<String> getPackageDependencies() throws IOException {
        return Collections.emptyList();
    }

    public FileObject resolvePackageRoot(FileSystemManager fileSystemManager) throws FileSystemException {
        throw new EvalException("Cannot access package root", new Object[0]);
    }
}

