/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.renjin.primitives.packaging.FileBasedPackage;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.repackaged.guava.io.Resources;
import org.renjin.util.NamedByteSource;

public class ClasspathPackage
extends FileBasedPackage {
    private ClassLoader classLoader;

    public ClasspathPackage(ClassLoader classLoader, FqPackageName name) {
        super(name);
        this.classLoader = classLoader;
    }

    public ClasspathPackage(FqPackageName name) {
        this(ClasspathPackage.class.getClassLoader(), name);
    }

    public boolean exists() {
        return this.resourceExists("environment");
    }

    @Override
    public NamedByteSource getResource(String name) throws IOException {
        String qualifiedName = this.qualifyResourceName(name);
        URL url2 = this.classLoader.getResource(qualifiedName);
        if (url2 == null) {
            throw new IOException(String.format("Could not find %s (%s)", name, qualifiedName));
        }
        try {
            return new NamedByteSource(name, Resources.asByteSource(url2));
        }
        catch (Exception e) {
            throw new IOException(String.format("Could not load %s (%s)", name, url2.toString()), e);
        }
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    @Override
    public FileObject resolvePackageRoot(FileSystemManager fileSystemManager) throws FileSystemException {
        FileObject environmentFileObject;
        String qualifiedName = this.qualifyResourceName("environment");
        String uri = "res:" + qualifiedName;
        try {
            environmentFileObject = fileSystemManager.resolveFile(uri);
        }
        catch (FileSystemException e) {
            throw new FileSystemException("Exception locating package resource '" + uri + "' using the provided VirtualFileSystem, check your Renjin Session configuration.", (Throwable)e);
        }
        if (!environmentFileObject.exists()) {
            throw new FileSystemException("Could not locate resource '" + uri + "' using the provided VirtualFileSystem, check your Renjin Session configuration.");
        }
        return environmentFileObject.getParent();
    }

    private String qualifyResourceName(String name) {
        return this.getName().getGroupId().replace('.', '/') + "/" + this.getName().getPackageName() + "/" + name;
    }

    @Override
    public boolean resourceExists(String name) {
        URL url2 = this.classLoader.getResource(this.qualifyResourceName(name));
        return url2 != null;
    }
}

