/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.serialization;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import org.renjin.primitives.io.serialization.RDataReader;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;

public class StringByteArrayVector
extends StringVector {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private final byte[] buffer;
    private final Charset charset;
    private final CharsetDecoder decoder;
    private int[] offsets;
    private int length;

    private StringByteArrayVector(int[] offsets, byte[] buffer, Charset charset, AttributeMap attributeMap) {
        super(attributeMap);
        this.offsets = offsets;
        this.buffer = buffer;
        this.charset = charset;
        this.decoder = charset.newDecoder();
        this.length = offsets.length - 1;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    protected StringVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new StringByteArrayVector(this.offsets, this.buffer, this.charset, attributes2);
    }

    @Override
    public String getElementAsString(int index) {
        int offset = this.offsets[index];
        if (offset < 0) {
            return null;
        }
        int endPos = this.offsets[index + 1];
        if (endPos < 0) {
            endPos = -endPos;
        }
        int length2 = endPos - offset;
        return new String(this.buffer, offset, length2, this.charset);
    }

    @Override
    public boolean isElementNA(int index) {
        return this.offsets[index] < 0;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StringByteArrayVector{");
        for (int i = 0; i < Math.min(10, this.length()); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            if (this.isElementNA(i)) {
                sb.append("NA");
                continue;
            }
            sb.append("'").append(this.getElementAsString(i)).append("'");
        }
        if (this.length() > 10) {
            sb.append(",... ").append(this.length()).append(" elements in total");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private int[] offsets;
        private byte[] buffer;
        private int currentOffset = 0;
        private int currentIndex = 0;
        private Charset charset = Charset.defaultCharset();

        public Builder(int numElements) {
            this.offsets = new int[numElements + 1];
            this.buffer = new byte[1024];
        }

        public void addNA() {
            this.offsets[this.currentIndex++] = -1;
        }

        public void readFrom(RDataReader.StreamReader in, int length2) throws IOException {
            if (length2 < 0) {
                this.offsets[this.currentIndex] = -this.currentOffset;
            } else {
                int minimumCapacity = this.currentOffset + length2;
                if (minimumCapacity > this.buffer.length) {
                    this.grow(minimumCapacity);
                }
                this.offsets[this.currentIndex] = this.currentOffset;
                in.readFully(this.buffer, this.currentOffset, length2);
                this.currentOffset += length2;
            }
            ++this.currentIndex;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        private void grow(int minCapacity) {
            int oldCapacity = this.buffer.length;
            double averageElementSize = (double)this.currentOffset / (double)this.currentIndex;
            int expectedCapacity = (int)(averageElementSize * (double)this.offsets.length);
            int newCapacity = expectedCapacity > minCapacity ? expectedCapacity : oldCapacity << 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = Builder.hugeCapacity(minCapacity);
            }
            this.buffer = Arrays.copyOf(this.buffer, newCapacity);
        }

        private static int hugeCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }

        public SEXP build(AttributeMap attributeMap) {
            if (this.currentIndex != this.offsets.length - 1) {
                throw new IllegalStateException("Expected " + (this.offsets.length - 1) + " elements, but only " + this.currentIndex + " added.");
            }
            this.offsets[this.currentIndex] = this.currentOffset;
            int excessCapacity = this.buffer.length - this.currentOffset;
            if (excessCapacity > 10240) {
                this.buffer = Arrays.copyOf(this.buffer, this.currentOffset);
            }
            return new StringByteArrayVector(this.offsets, this.buffer, this.charset, attributeMap);
        }
    }
}

