/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import org.renjin.eval.EvalException;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.OpenSpec;
import org.renjin.primitives.io.connections.PushbackBufferedReader;
import org.renjin.primitives.io.connections.Sink;
import org.renjin.repackaged.guava.base.Preconditions;

public class StdOutConnection
implements Connection {
    private PrintWriter stream;
    private Deque<Sink> sinkStack = new ArrayDeque<Sink>();

    public StdOutConnection() {
        this.stream = new PrintWriter(System.out);
    }

    public void setStream(PrintWriter stream) {
        this.stream = stream;
    }

    public PrintWriter getStream() {
        return this.stream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new EvalException("cannot read from stdout", new Object[0]);
    }

    @Override
    public PushbackBufferedReader getReader() throws IOException {
        throw new EvalException("cannot read from stdout", new Object[0]);
    }

    @Override
    public PrintWriter getPrintWriter() {
        return this.getOpenPrintWriter();
    }

    @Override
    public PrintWriter getOpenPrintWriter() {
        if (this.sinkStack.isEmpty()) {
            return this.stream;
        }
        return this.sinkStack.peek().getPrintWriter(this.stream);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new EvalException("Cannot open stdout for binary output, only text (todo?)", new Object[0]);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open(OpenSpec spec) throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    public int getSinkStackHeight() {
        return this.sinkStack.size();
    }

    @Override
    public String getClassName() {
        return "terminal";
    }

    @Override
    public String getDescription() {
        return "stdout";
    }

    @Override
    public String getMode() {
        return "w";
    }

    @Override
    public boolean canRead() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public Connection.Type getType() {
        return Connection.Type.TEXT;
    }

    void sink(Sink sink2) throws IOException {
        Preconditions.checkNotNull(sink2, "sink");
        this.sinkStack.push(sink2);
    }

    Sink clearSink() throws IOException {
        if (!this.sinkStack.isEmpty()) {
            return this.sinkStack.pop();
        }
        return null;
    }
}

