/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.OpenSpec;
import org.renjin.primitives.io.connections.PushbackBufferedReader;

public class SocketConnection
implements Connection {
    private final Socket socket;
    private PushbackBufferedReader reader;
    private PrintWriter writer;
    private String description;
    private OpenSpec openSpec = new OpenSpec("rw");

    public SocketConnection(String host, int port) throws UnknownHostException, IOException {
        this.socket = new Socket(host, port);
        this.description = host + ":" + port;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public PushbackBufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new PushbackBufferedReader(new InputStreamReader(this.getInputStream()));
        }
        return this.reader;
    }

    @Override
    public PrintWriter getPrintWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(this.getOutputStream());
        }
        return this.writer;
    }

    @Override
    public PrintWriter getOpenPrintWriter() {
        if (this.writer == null) {
            throw new IllegalStateException("not open");
        }
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.socket.close();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public void open(OpenSpec spec) throws IOException {
        this.openSpec = spec;
    }

    @Override
    public String getClassName() {
        return "socket";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getMode() {
        return "rw";
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public Connection.Type getType() {
        return this.openSpec.getType();
    }
}

