/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.renjin.eval.EvalException;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.repackaged.guava.io.ByteStreams;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class BinaryReader {
    private InputStream in;

    public BinaryReader(RawVector rawVector) {
        this(new ByteArrayInputStream(rawVector.toByteArrayUnsafe()));
    }

    public BinaryReader(InputStream inputStream) {
        this.in = inputStream;
    }

    public Vector readIntVector(int n, int size, boolean signed, boolean swap) throws IOException {
        if (IntVector.isNA(size)) {
            size = 4;
        }
        if (size != 4) {
            throw new EvalException("TODO: size = " + size, new Object[0]);
        }
        if (!signed) {
            throw new EvalException("TODO: signed = false", new Object[0]);
        }
        if (swap) {
            throw new EvalException("TODO: swap = TRUE", new Object[0]);
        }
        int[] vector2 = new int[n];
        byte[] buffer = new byte[size];
        for (int i = 0; i < n; ++i) {
            ByteStreams.readFully(this.in, buffer);
            vector2[i] = buffer[3] << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
        }
        return IntArrayVector.unsafe(vector2);
    }

    public Vector readDoubleVector(int n, int size, boolean swap) throws IOException {
        double[] values;
        if (IntVector.isNA(size)) {
            size = 8;
        }
        switch (size) {
            case 4: {
                values = this.readBinFloatArray(n, swap);
                break;
            }
            case 8: {
                values = this.readBinDoubleArray(n, swap);
                break;
            }
            default: {
                throw new EvalException("Unsupported size = " + size + " for numeric vector", new Object[0]);
            }
        }
        return DoubleArrayVector.unsafe(values);
    }

    public Vector readComplexVector(int n, int size, boolean swap) throws IOException {
        double[] values;
        if (IntVector.isNA(size)) {
            size = 16;
        }
        switch (size) {
            case 8: {
                values = this.readBinFloatArray(n * 2, swap);
                break;
            }
            case 16: {
                values = this.readBinDoubleArray(n * 2, swap);
                break;
            }
            default: {
                throw new EvalException("Unsupported size = " + size + " for complex vector", new Object[0]);
            }
        }
        return ComplexArrayVector.unsafe(values);
    }

    private double[] readBinDoubleArray(int n, boolean swap) throws IOException {
        double[] vector2 = new double[n];
        byte[] buffer = new byte[8];
        for (int i = 0; i < n; ++i) {
            ByteStreams.readFully(this.in, buffer);
            long longValue = swap ? ((long)buffer[0] << 56) + ((long)(buffer[1] & 0xFF) << 48) + ((long)(buffer[2] & 0xFF) << 40) + ((long)(buffer[3] & 0xFF) << 32) + ((long)(buffer[4] & 0xFF) << 24) + (long)((buffer[5] & 0xFF) << 16) + (long)((buffer[6] & 0xFF) << 8) + (long)((buffer[7] & 0xFF) << 0) : ((long)buffer[7] << 56) + ((long)(buffer[6] & 0xFF) << 48) + ((long)(buffer[5] & 0xFF) << 40) + ((long)(buffer[4] & 0xFF) << 32) + ((long)(buffer[3] & 0xFF) << 24) + (long)((buffer[2] & 0xFF) << 16) + (long)((buffer[1] & 0xFF) << 8) + (long)((buffer[0] & 0xFF) << 0);
            vector2[i] = Double.longBitsToDouble(longValue);
        }
        return vector2;
    }

    private double[] readBinFloatArray(int n, boolean swap) throws IOException {
        double[] vector2 = new double[n];
        byte[] buffer = new byte[4];
        for (int i = 0; i < n; ++i) {
            ByteStreams.readFully(this.in, buffer);
            int intValue = swap ? buffer[0] << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF : buffer[3] << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
            vector2[i] = Float.intBitsToFloat(intValue);
        }
        return vector2;
    }

    public Vector readCharacterVector(int n, int size, boolean swap) throws IOException {
        StringVector.Builder vector2 = new StringVector.Builder(0, n);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < n; ++i) {
            int b;
            buffer.reset();
            while ((b = this.in.read()) > 0) {
                buffer.write(b);
            }
            vector2.add(buffer.toString(Charsets.UTF_8.name()));
        }
        return vector2.build();
    }

    public Vector readRaw(int n, int size) throws IOException {
        int byteCount = n;
        byte[] buffer = new byte[byteCount];
        int offset = 0;
        while (byteCount > 0) {
            int bytesRead = this.in.read(buffer, offset, byteCount);
            byteCount -= bytesRead;
            offset += bytesRead;
        }
        return RawVector.unsafe(buffer);
    }
}

