/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine.view;

import org.renjin.primitives.combine.view.CompositeIntColumnMatrix;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class CombinedIntVector
extends IntVector
implements DeferredComputation {
    private final Vector[] vectors;
    private final int[] endIndex;
    private final int totalLength;

    public static IntVector combine(Vector[] vectors, AttributeMap attributeMap) {
        if (vectors.length == 1) {
            return (IntVector)vectors[0].setAttributes(attributeMap);
        }
        if (CombinedIntVector.equalLength(vectors)) {
            return new CompositeIntColumnMatrix(vectors, attributeMap);
        }
        return new CombinedIntVector(vectors, attributeMap);
    }

    private static boolean equalLength(Vector[] vectors) {
        int length2 = vectors[0].length();
        for (int i = 1; i < vectors.length; ++i) {
            if (vectors[i].length() == length2) continue;
            return false;
        }
        return true;
    }

    private CombinedIntVector(Vector[] vectors, AttributeMap attributeMap) {
        super(attributeMap);
        this.vectors = vectors;
        this.endIndex = new int[vectors.length];
        int totalLength = 0;
        for (int i = 0; i != vectors.length; ++i) {
            this.endIndex[i] = totalLength += vectors[i].length();
        }
        this.totalLength = totalLength;
    }

    @Override
    public Vector[] getOperands() {
        return this.vectors;
    }

    public int[] getEndIndices() {
        return this.endIndex;
    }

    @Override
    public String getComputationName() {
        return "c";
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new CombinedIntVector(this.vectors, attributes2);
    }

    @Override
    public int getElementAsInt(int index) {
        if (index < this.endIndex[0]) {
            return this.vectors[0].getElementAsInt(index);
        }
        if (index < this.endIndex[1]) {
            return this.vectors[1].getElementAsInt(index - this.endIndex[0]);
        }
        if (index < this.endIndex[2]) {
            return this.vectors[2].getElementAsInt(index - this.endIndex[1]);
        }
        if (index < this.endIndex[3]) {
            return this.vectors[3].getElementAsInt(index - this.endIndex[2]);
        }
        for (int i = 4; i < this.vectors.length; ++i) {
            if (index >= this.endIndex[i]) continue;
            return this.vectors[i].getElementAsInt(index - this.endIndex[i - 1]);
        }
        throw new IllegalArgumentException("index: " + index);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    @Override
    public int length() {
        return this.totalLength;
    }
}

