/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.TypeSet;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.eval.Calls;
import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.eval.DispatchChain;
import org.renjin.eval.EvalException;
import org.renjin.eval.Profiler;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.primitives.Primitives;
import org.renjin.primitives.Types;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.s4.S4;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Closure;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.HashFrame;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class S3 {
    public static final Set<String> GROUPS = Sets.newHashSet("Ops", "Math", "Summary");
    private static final Set<String> SPECIAL = Sets.newHashSet("$", "$<-");
    public static final Symbol METHODS_TABLE = Symbol.get(".__S3MethodsTable__.");
    private static final Symbol NA_RM = Symbol.get("na.rm");

    @Builtin
    public static SEXP UseMethod(@Current Context context, String genericMethodName) {
        if (context.getArguments().length() == 0) {
            return S3.UseMethod(context, genericMethodName, Null.INSTANCE);
        }
        SEXP object2 = context.evaluate((SEXP)context.getArguments().getElementAsSEXP(0), context.getParent().getEnvironment());
        return S3.UseMethod(context, genericMethodName, object2);
    }

    @Builtin
    public static SEXP UseMethod(@Current Context context, String genericMethodName, SEXP object2) {
        return Resolver.start(context, genericMethodName, object2).withDefinitionEnvironment(((Closure)context.getFunction()).getEnclosingEnvironment()).next().apply(context, context.getEnvironment());
    }

    @Internal
    public static SEXP NextMethod(@Current Context context, @Current Environment env2, SEXP generic, SEXP object2, @ArgumentList ListVector extraArgs) {
        return Resolver.resume(context).withGenericArgument(generic).withObjectArgument(object2).next().applyNext(context, context.getEnvironment(), extraArgs);
    }

    public static StringVector computeDataClasses(ValueBounds valueBounds) {
        if (!valueBounds.isClassAttributeConstant()) {
            return null;
        }
        AtomicVector classAttribute = valueBounds.getConstantClassAttribute();
        if (classAttribute.length() > 0) {
            return (StringVector)classAttribute;
        }
        if (!valueBounds.isDimCountConstant()) {
            return null;
        }
        int typeSet = valueBounds.getTypeSet();
        String implicitClass = TypeSet.implicitClass(typeSet);
        if (implicitClass == null) {
            return null;
        }
        StringVector.Builder dataClass = new StringVector.Builder();
        int dimCount = valueBounds.getConstantDimCount();
        if (dimCount == 2) {
            dataClass.add("matrix");
        } else if (dimCount > 0) {
            dataClass.add("array");
        }
        dataClass.add(implicitClass);
        if ((typeSet & 0x30) != 0) {
            dataClass.add("numeric");
        }
        return dataClass.build();
    }

    public static StringVector computeDataClasses(Context context, SEXP exp2) {
        SEXP classAttribute = (exp2 = exp2.force(context)).getAttribute(Symbols.CLASS);
        if (classAttribute.length() > 0) {
            return (StringVector)classAttribute;
        }
        StringVector.Builder dataClass = new StringVector.Builder();
        SEXP dim2 = exp2.getAttribute(Symbols.DIM);
        if (dim2.length() == 2) {
            dataClass.add("matrix");
        } else if (dim2.length() > 0) {
            dataClass.add("array");
        }
        if (exp2 instanceof IntVector) {
            dataClass.add("integer");
            dataClass.add("numeric");
        } else if (exp2 instanceof DoubleVector) {
            dataClass.add("double");
            dataClass.add("numeric");
        } else {
            dataClass.add(exp2.getImplicitClass());
        }
        return dataClass.build();
    }

    public static SEXP dispatchGroup(String group, FunctionCall call2, String opName, PairList args2, Context context, Environment rho) {
        if (call2.getFunction() instanceof Symbol && ((Symbol)call2.getFunction()).getPrintName().endsWith(".default")) {
            return null;
        }
        boolean isOps = group.equals("Ops");
        int nargs2 = isOps ? args2.length() : 1;
        for (int k = 0; k < nargs2; ++k) {
            if (!Types.isS4(args2.getElementAsSEXP(k))) continue;
            return S4.tryS4DispatchFromPrimitive(context, args2.getElementAsSEXP(0), args2, rho, group, opName);
        }
        if (opName.equals("%*%")) {
            return null;
        }
        GenericMethod left = Resolver.start(context, rho, group, opName, args2.getElementAsSEXP(0)).withBaseDefinitionEnvironment().findNext();
        GenericMethod right = null;
        if (nargs2 == 2) {
            right = Resolver.start(context, rho, group, opName, args2.getElementAsSEXP(1)).withBaseDefinitionEnvironment().findNext();
        }
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            left = right;
        }
        String[] m = new String[nargs2];
        for (int i = 0; i < nargs2; ++i) {
            StringVector t2 = S3.computeDataClasses(context, args2.getElementAsSEXP(i));
            boolean set2 = false;
            for (int j = 0; j < t2.length(); ++j) {
                if (!t2.getElementAsString(j).equals(left.className)) continue;
                m[i] = left.method.getPrintName();
                set2 = true;
                break;
            }
            if (set2) continue;
            m[i] = "";
        }
        left.withMethodVector(m);
        PairList promisedArgs = Calls.promiseArgs(args2, context, rho);
        if (promisedArgs.length() != args2.length()) {
            throw new EvalException("dispatch error in group dispatch", new Object[0]);
        }
        if (promisedArgs != Null.INSTANCE) {
            PairList.Node promised = (PairList.Node)promisedArgs;
            while (true) {
                if (promised == promisedArgs) {
                    ((Promise)promised.getValue()).setResult(((PairList.Node)args2).getValue());
                }
                if (isOps) {
                    promised.setTag(Null.INSTANCE);
                }
                if (!promised.hasNextNode()) break;
                promised = promised.getNextNode();
            }
        }
        return left.doApply(context, rho, call2, promisedArgs);
    }

    public static SEXP tryDispatchFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, SEXP object2, PairList args2) {
        if (call2.getFunction() instanceof Symbol && ((Symbol)call2.getFunction()).getPrintName().endsWith(".default")) {
            return null;
        }
        SEXP resultS4Dispatch = null;
        if (Types.isS4(object2) && S3.isS4DispatchSupported(name)) {
            resultS4Dispatch = S4.tryS4DispatchFromPrimitive(context, object2, args2, rho, null, name);
        }
        if (resultS4Dispatch != null) {
            return resultS4Dispatch;
        }
        GenericMethod method = Resolver.start(context, rho, null, name, object2).withBaseDefinitionEnvironment().withObjectArgument(object2).withGenericArgument(name).findNext();
        if (method == null) {
            return null;
        }
        PairList newArgs = S3.reassembleAndEvaluateArgs(object2, args2, context, rho);
        Context fakeContext = context.beginFunction(rho, call2, new Closure(rho, Null.INSTANCE, Null.INSTANCE), args2);
        return method.doApply(fakeContext, rho, call2, newArgs);
    }

    private static boolean isS4DispatchSupported(String name) {
        return !"@<-".equals(name);
    }

    public static SEXP tryDispatchFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, String[] argumentNames, SEXP[] arguments) {
        if (call2.getFunction() instanceof Symbol && ((Symbol)call2.getFunction()).getPrintName().endsWith(".default")) {
            return null;
        }
        Vector classVector = (Vector)arguments[0].getAttribute(Symbols.CLASS);
        if (classVector.length() == 0) {
            return null;
        }
        DispatchChain chain = DispatchChain.newChain(context, rho, name, classVector);
        if (chain == null) {
            return null;
        }
        PairList.Builder newArgsBuilder = new PairList.Builder();
        for (int i = 0; i != arguments.length; ++i) {
            newArgsBuilder.add(argumentNames[i], arguments[i]);
        }
        PairList newArgs = newArgsBuilder.build();
        FunctionCall newCall = new FunctionCall(chain.getMethodSymbol(), newArgs);
        ClosureDispatcher dispatcher = new ClosureDispatcher(context, rho, newCall);
        return dispatcher.apply(chain, newArgs);
    }

    static PairList reassembleAndEvaluateArgs(SEXP object2, PairList args2, Context context, Environment rho) {
        PairList.Builder newArgs = new PairList.Builder();
        PairList.Node firstArg = (PairList.Node)args2;
        newArgs.add(firstArg.getRawTag(), (SEXP)new Promise(firstArg.getValue(), object2));
        ArgumentIterator argIt = new ArgumentIterator(context, rho, firstArg.getNext());
        while (argIt.hasNext()) {
            PairList.Node node = argIt.nextNode();
            if (node.getValue() == Symbol.MISSING_ARG) {
                newArgs.add(node.getRawTag(), (SEXP)Symbol.MISSING_ARG);
                continue;
            }
            newArgs.add(node.getRawTag(), (SEXP)Promise.repromise(rho, node.getValue()));
        }
        return newArgs.build();
    }

    public static SEXP tryDispatchOpsFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, SEXP s0) {
        PairList.Node newArgs = new PairList.Node(s0, Null.INSTANCE);
        return S3.dispatchGroup("Ops", call2, name, newArgs, context, rho);
    }

    public static SEXP tryDispatchOpsFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, SEXP s0, SEXP s1) {
        PairList.Node newArgs = new PairList.Node(s0, new PairList.Node(s1, Null.INSTANCE));
        return S3.dispatchGroup("Ops", call2, name, newArgs, context, rho);
    }

    public static SEXP tryDispatchGroupFromPrimitive(Context context, Environment rho, FunctionCall call2, String group, String name, SEXP s0, PairList args2) {
        PairList.Node firstNode = (PairList.Node)args2;
        PairList.Node newArgs = new PairList.Node(s0, firstNode.getNext());
        return S3.dispatchGroup(group, call2, name, newArgs, context, rho);
    }

    public static SEXP tryDispatchSummaryFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, ListVector evaluatedArguments, boolean naRm) {
        PairList.Builder newArgs = new PairList.Builder();
        int varArgIndex = 0;
        boolean naRmArgumentSupplied = false;
        for (PairList.Node node : call2.getArguments().nodes()) {
            if (node.getRawTag() == NA_RM) {
                newArgs.add(node.getTag(), (SEXP)new LogicalArrayVector(naRm));
                naRmArgumentSupplied = true;
                continue;
            }
            if (node.getValue() == Symbols.ELLIPSES) {
                while (varArgIndex < evaluatedArguments.length()) {
                    newArgs.add(evaluatedArguments.getName(varArgIndex), evaluatedArguments.get(varArgIndex));
                    ++varArgIndex;
                }
                continue;
            }
            newArgs.add(node.getRawTag(), evaluatedArguments.get(varArgIndex++));
        }
        if (!naRmArgumentSupplied) {
            newArgs.add(NA_RM, LogicalVector.valueOf(naRm));
        }
        return S3.dispatchGroup("Summary", call2, name, newArgs.build(), context, rho);
    }

    public static Environment findMethodTable(Context context, Environment definitionEnvironment) {
        SEXP table = definitionEnvironment.getVariableUnsafe(METHODS_TABLE).force(context);
        if (table instanceof Environment) {
            return (Environment)table;
        }
        if (table == Symbol.UNBOUND_VALUE) {
            return Environment.EMPTY;
        }
        throw new EvalException("Unexpected value for .__S3MethodsTable__. in " + definitionEnvironment.getName(), new Object[0]);
    }

    public static PairList updateArguments(Context context, PairList actuals, PairList formals2, Environment previousEnv, ListVector extraArgs) {
        ArrayList<SEXP> actualNames = Lists.newArrayList();
        ArrayList<SEXP> actualValues = Lists.newArrayList();
        ArrayList<Symbol> matchedNames = Lists.newArrayList();
        LinkedList<PairList.Node> unmatchedFormals = Lists.newLinkedList(formals2.nodes());
        for (PairList.Node node : actuals.nodes()) {
            if (node.getValue() instanceof PromisePairList) {
                PromisePairList ellipses = (PromisePairList)node.getValue();
                for (PairList.Node nestedNode : ellipses.nodes()) {
                    actualNames.add(nestedNode.getRawTag());
                    actualValues.add(nestedNode.getValue());
                    matchedNames.add(S3.matchArgumentExactlyByName(nestedNode.getRawTag(), unmatchedFormals));
                }
                continue;
            }
            actualNames.add(node.getRawTag());
            actualValues.add(node.getValue());
            matchedNames.add(S3.matchArgumentExactlyByName(node.getRawTag(), unmatchedFormals));
        }
        for (int i = 0; i != matchedNames.size(); ++i) {
            if (matchedNames.get(i) != null) continue;
            matchedNames.set(i, S3.matchPartiallyByName((SEXP)actualNames.get(i), unmatchedFormals));
        }
        Iterator formalIt = unmatchedFormals.iterator();
        for (int i = 0; i != matchedNames.size(); ++i) {
            if (matchedNames.get(i) != null) continue;
            if (!formalIt.hasNext()) {
                throw new EvalException("Unmatched argument", new Object[0]);
            }
            Symbol nextFormalName = ((PairList.Node)formalIt.next()).getTag();
            if (nextFormalName == Symbols.ELLIPSES) break;
            matchedNames.set(i, nextFormalName);
        }
        PairList.Builder updated = PairList.Node.newBuilder();
        for (int i = 0; i != matchedNames.size(); ++i) {
            SEXP updatedValue;
            if (matchedNames.get(i) != null) {
                updatedValue = previousEnv.getVariableUnsafe((Symbol)matchedNames.get(i));
                assert (updatedValue != Symbol.UNBOUND_VALUE);
            } else {
                updatedValue = (SEXP)actualValues.get(i);
            }
            updated.add((SEXP)actualNames.get(i), updatedValue);
        }
        for (NamedValue extraArg : extraArgs.namedValues()) {
            if (!extraArg.hasName()) {
                updated.add(extraArg.getValue());
                continue;
            }
            updated.set(extraArg.getName(), extraArg.getValue());
        }
        return updated.build();
    }

    private static Symbol matchArgumentExactlyByName(SEXP tag, List<PairList.Node> unmatchedFormals) {
        if (tag == Null.INSTANCE) {
            return null;
        }
        for (PairList.Node formal : unmatchedFormals) {
            if (formal.getTag() != tag) continue;
            unmatchedFormals.remove(formal);
            return formal.getTag();
        }
        return null;
    }

    private static Symbol matchPartiallyByName(SEXP tag, List<PairList.Node> unmatchedFormals) {
        if (tag == Null.INSTANCE) {
            return null;
        }
        String name = ((Symbol)tag).getPrintName();
        PairList.Node partialMatch = null;
        for (PairList.Node formal : unmatchedFormals) {
            if (!formal.getTag().getPrintName().startsWith(name)) continue;
            if (partialMatch != null) {
                throw new EvalException("multiple partial matches", new Object[0]);
            }
            partialMatch = formal;
        }
        if (partialMatch == null) {
            return null;
        }
        return partialMatch.getTag();
    }

    public static class GenericMethod {
        private Resolver resolver;
        private Symbol method;
        private Function function;
        private String className;
        private StringVector methodVector;

        public GenericMethod(Resolver resolver, Symbol method, String className, Function function2) {
            assert (function2 != null);
            this.resolver = resolver;
            this.method = method;
            this.methodVector = new StringArrayVector(method.getPrintName());
            this.className = className;
            this.function = function2;
        }

        public SEXP apply(Context callContext, Environment callEnvironment) {
            PairList rePromisedArgs = Calls.promiseArgs(callContext.getArguments(), callContext, callEnvironment);
            return this.doApply(callContext, callEnvironment, callContext.getCall(), rePromisedArgs);
        }

        public SEXP applyNext(Context context, Environment environment2, ListVector extraArgs) {
            Context originalCallingContext = this.findOriginalCallingContext(context);
            PairList arguments = this.nextArguments(originalCallingContext, extraArgs);
            if ("Ops".equals(this.resolver.group) && arguments.length() == 2) {
                this.withMethodVector(this.groupsMethodVector());
            }
            return this.doApply(context, environment2, originalCallingContext.getCall(), arguments);
        }

        private String[] groupsMethodVector() {
            GenericMethod previousMethod = this.resolver.previousContext.getState(GenericMethod.class);
            String[] methodVector = previousMethod.methodVector.toArray();
            String methodName = this.methodVector.getElementAsString(0);
            for (int i = 0; i < methodVector.length; ++i) {
                if (methodVector[i].equals("")) continue;
                methodVector[i] = methodName;
            }
            return methodVector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SEXP doApply(Context callContext, Environment callEnvironment, FunctionCall call2, PairList promisedArgs) {
            FunctionCall newCall = new FunctionCall(this.method, call2.getArguments());
            callContext.setState(GenericMethod.class, this);
            if (Profiler.ENABLED) {
                Profiler.functionStart(this.method, this.function);
            }
            try {
                if (this.function instanceof Closure) {
                    Environment callingEnvironment = callContext.getCallingEnvironment();
                    if (callingEnvironment == null) {
                        callingEnvironment = callContext.getGlobalEnvironment();
                    }
                    SEXP sEXP = Calls.applyClosure((Closure)this.function, callContext, callingEnvironment, newCall, promisedArgs, this.persistChain());
                    return sEXP;
                }
                SEXP sEXP = this.function.apply(callContext, callEnvironment, newCall, promisedArgs);
                return sEXP;
            }
            finally {
                callContext.clearState(GenericMethod.class);
                if (Profiler.ENABLED) {
                    Profiler.functionEnd();
                }
            }
        }

        public GenericMethod withMethodVector(String[] methodNames) {
            this.methodVector = new StringArrayVector(methodNames);
            return this;
        }

        public PairList nextArguments(Context parentContext, ListVector extraArgs) {
            PairList actuals = parentContext.getArguments();
            Closure closure = (Closure)parentContext.getFunction();
            PairList formals2 = closure.getFormals();
            Environment previousEnv = parentContext.getEnvironment();
            return S3.updateArguments(parentContext, actuals, formals2, previousEnv, extraArgs);
        }

        private Context findOriginalCallingContext(Context callContext) {
            Context parentContext = callContext.getParent();
            while (parentContext.getParent() != this.resolver.previousContext) {
                parentContext = parentContext.getParent();
            }
            return parentContext;
        }

        private Frame persistChain() {
            HashFrame frame2 = new HashFrame();
            frame2.setVariable(Symbol.get(".Class"), new StringArrayVector(this.resolver.classes));
            frame2.setVariable(Symbol.get(".Method"), this.methodVector);
            frame2.setVariable(Symbol.get(".Generic"), StringVector.valueOf(this.resolver.genericMethodName));
            frame2.setVariable(Symbol.get(".GenericCallEnv"), this.resolver.callingEnvironment);
            frame2.setVariable(Symbol.get(".GenericDefEnv"), this.resolver.definitionEnvironment);
            return frame2;
        }

        public String toString() {
            return this.method + "." + this.className;
        }

        public List<String> nextClasses() {
            if (this.className == null) {
                return Collections.emptyList();
            }
            int myIndex = this.resolver.classes.indexOf(this.className);
            return this.resolver.classes.subList(myIndex + 1, this.resolver.classes.size());
        }
    }

    private static class Resolver {
        private Environment callingEnvironment;
        private Environment definitionEnvironment = Environment.EMPTY;
        private String group;
        private String genericMethodName;
        private List<String> classes;
        private Context context;
        private SEXP object;
        private Context previousContext;

        private Resolver() {
        }

        private static Resolver start(Context context, String genericMethodName, SEXP object2) {
            return Resolver.start(context, context.getEnvironment(), null, genericMethodName, object2);
        }

        private static Resolver start(Context context, Environment rho, String group, String genericMethodName, SEXP object2) {
            Resolver resolver = new Resolver();
            resolver.callingEnvironment = rho;
            resolver.genericMethodName = genericMethodName;
            resolver.context = context;
            resolver.object = object2;
            resolver.group = group;
            StringVector objectClasses = S3.computeDataClasses(context, object2);
            if (Types.isS4(object2)) {
                AtomicVector objectClassesS4 = S4.computeDataClassesS4(context, objectClasses.getElementAsString(0));
                if (objectClassesS4 != Null.INSTANCE) {
                    ArrayList<String> classes = Lists.newArrayList(objectClasses);
                    classes.addAll(Lists.newArrayList((StringVector)objectClassesS4));
                    resolver.classes = classes;
                } else {
                    resolver.classes = Lists.newArrayList(objectClasses);
                }
            } else {
                resolver.classes = Lists.newArrayList(objectClasses);
            }
            return resolver;
        }

        public static Resolver resume(Context context) {
            Context parentContext = Resolver.findParentContext(context);
            GenericMethod method = parentContext.getState(GenericMethod.class);
            Resolver resolver = new Resolver();
            resolver.context = context;
            resolver.previousContext = parentContext;
            resolver.callingEnvironment = context.getEnvironment();
            resolver.definitionEnvironment = ((GenericMethod)method).resolver.definitionEnvironment;
            resolver.genericMethodName = ((GenericMethod)method).resolver.genericMethodName;
            resolver.classes = method.nextClasses();
            resolver.group = ((GenericMethod)method).resolver.group;
            resolver.object = ((GenericMethod)method).resolver.object;
            return resolver;
        }

        public Resolver withObjectArgument(SEXP object2) {
            if (object2 != Null.INSTANCE) {
                this.object = object2;
            }
            return this;
        }

        public Resolver withGenericArgument(SEXP generic) {
            if (generic != Null.INSTANCE) {
                this.genericMethodName = generic.asString();
            }
            return this;
        }

        public Resolver withGenericArgument(String genericName) {
            this.genericMethodName = genericName;
            return this;
        }

        public Resolver withDefinitionEnvironment(Environment rho) {
            this.definitionEnvironment = rho;
            return this;
        }

        public Resolver withBaseDefinitionEnvironment() {
            this.definitionEnvironment = this.context.getBaseEnvironment();
            return this;
        }

        private static Context findParentContext(Context context) {
            while (context != null) {
                if (context.getState(GenericMethod.class) != null) {
                    return context;
                }
                context = context.getParent();
            }
            throw new EvalException("NextMethod called out of context", new Object[0]);
        }

        public GenericMethod next() {
            GenericMethod next = this.findNextOrDefault();
            if (next == null) {
                throw new EvalException("no applicable method for '%s' applied to an object of class \"%s\"", this.genericMethodName, this.classes.toString());
            }
            return next;
        }

        private GenericMethod findNextOrDefault() {
            GenericMethod next = this.findNext();
            if (next != null) {
                return next;
            }
            GenericMethod function2 = this.findNext(this.definitionEnvironment, this.genericMethodName, "default");
            if (function2 != null) {
                return function2;
            }
            function2 = this.findNext(this.getMethodTable(), this.genericMethodName, "default");
            if (function2 != null) {
                return function2;
            }
            PrimitiveFunction primitive2 = Primitives.getBuiltin(this.genericMethodName);
            if (primitive2 != null) {
                return new GenericMethod(this, Symbol.get(this.genericMethodName + ".default"), null, primitive2);
            }
            return null;
        }

        public GenericMethod findNext() {
            Environment methodTable = this.getMethodTable();
            for (String className : this.classes) {
                GenericMethod method = this.findNext(methodTable, this.genericMethodName, className);
                if (method != null) {
                    return method;
                }
                if (this.group == null || (method = this.findNext(methodTable, this.group, className)) == null) continue;
                return method;
            }
            return null;
        }

        private GenericMethod findNext(Environment methodTable, String name, String className) {
            Symbol method = Symbol.get(name + "." + className);
            Function function2 = this.callingEnvironment.findFunction(this.context, method);
            if (function2 != null) {
                return new GenericMethod(this, method, className, function2);
            }
            if (methodTable.hasVariable(method)) {
                return new GenericMethod(this, method, className, (Function)methodTable.getVariableUnsafe(method).force(this.context));
            }
            return null;
        }

        private Environment getMethodTable() {
            return S3.findMethodTable(this.context, this.definitionEnvironment);
        }
    }
}

