/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.codegen.WrapperRuntime;
import org.renjin.primitives.files.Files;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class R$primitive$file$append
extends BuiltinFunction {
    public R$primitive$file$append() {
        super("file.append");
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, PairList args2) {
        try {
            ArgumentIterator argIt = new ArgumentIterator(context, environment2, args2);
            SEXP s0 = argIt.evalNext();
            SEXP s1 = argIt.evalNext();
            if (!argIt.hasNext()) {
                return R$primitive$file$append.doApply(context, environment2, s0, s1);
            }
            throw new EvalException("file.append: too many arguments, expected at most 2.", new Object[0]);
        }
        catch (ArgumentException e) {
            throw new EvalException(context, "Invalid argument: %s. Expected:\n\tfile.append(character, character)", e.getMessage());
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
    }

    public static SEXP doApply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        try {
            if (args2.length == 2) {
                return R$primitive$file$append.doApply(context, environment2, args2[0], args2[1]);
            }
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
        throw new EvalException("file.append: max arity is 2", new Object[0]);
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        return R$primitive$file$append.doApply(context, environment2, call2, argNames, args2);
    }

    public static SEXP doApply(Context context, Environment environment2, SEXP arg0, SEXP arg1) throws Exception {
        if (arg0 instanceof Vector && StringVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg0) && arg1 instanceof Vector && StringVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg1)) {
            int cycles;
            Vector vector1 = WrapperRuntime.convertToVector(arg0);
            int length1 = vector1.length();
            int currentElementIndex1 = 0;
            Vector vector2 = WrapperRuntime.convertToVector(arg1);
            int length2 = vector2.length();
            int currentElementIndex2 = 0;
            if (length1 == 0 || length2 == 0) {
                cycles = 0;
            } else {
                cycles = 0;
                if (length1 > cycles) {
                    cycles = length1;
                }
                if (length2 > cycles) {
                    cycles = length2;
                }
            }
            int[] array2 = new int[cycles];
            for (int i = 0; i != cycles; ++i) {
                String s1 = vector1.getElementAsString(currentElementIndex1);
                String s2 = vector2.getElementAsString(currentElementIndex2);
                if (StringVector.isNA(s1) || StringVector.isNA(s2)) {
                    array2[i] = Integer.MIN_VALUE;
                } else {
                    int n = array2[i] = Files.fileAppend(context, s1, s2) ? 1 : 0;
                }
                if (++currentElementIndex1 == length1) {
                    currentElementIndex1 = 0;
                }
                if (++currentElementIndex2 != length2) continue;
                currentElementIndex2 = 0;
            }
            return new LogicalArrayVector(array2, AttributeMap.combineStructuralAttributes(vector1, vector2));
        }
        throw new EvalException(String.format("Invalid argument:\n\tfile.append(%s, %s)\n\tExpected:\n\tfile.append(character, character)", arg0.getTypeName(), arg1.getTypeName()), new Object[0]);
    }
}

