/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.ArrayList;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;

public class Contexts {
    private Contexts() {
    }

    @Internal(value="sys.nframe")
    public static int sysFrameCount(@Current Context context) {
        return Contexts.findCallingContext(context).getFrameDepth();
    }

    @Internal(value="parent.frame")
    public static Environment parentFrame(@Current Context context, int n) {
        if (n < 1) {
            throw new EvalException("invalid 'n' value", new Object[0]);
        }
        Context cptr = context;
        Environment t2 = cptr.getCallingEnvironment();
        while (!cptr.isTopLevel()) {
            if (cptr.getType() == Context.Type.FUNCTION && cptr.getEnvironment() == t2) {
                if (n == 1) {
                    return cptr.getCallingEnvironment();
                }
                --n;
                t2 = cptr.getCallingEnvironment();
            }
            cptr = cptr.getParent();
        }
        return context.getGlobalEnvironment();
    }

    @Internal(value="sys.parent")
    public static int sysParent(@Current Context context, int n) {
        int nframe2;
        Context cptr = Contexts.findCallingContext(context);
        int i = nframe2 = cptr.getFrameDepth();
        while (n-- > 0) {
            i = Contexts.R_sysparent(nframe2 - i + 1, cptr);
        }
        return i;
    }

    @Internal(value="sys.parents")
    public static SEXP sysParents(@Current Context context) {
        Context cptr = Contexts.findCallingContext(context);
        int nframe2 = cptr.getFrameDepth();
        int[] rval = new int[nframe2];
        for (int i = 0; i < nframe2; ++i) {
            rval[i] = Contexts.R_sysparent(nframe2 - i, cptr);
        }
        return new IntArrayVector(rval);
    }

    private static int R_sysparent(int n, Context cptr) {
        if (n <= 0) {
            throw new EvalException("only positive values of 'n' are allowed", new Object[0]);
        }
        while (!cptr.isTopLevel() && n > 1) {
            if (cptr.getType() == Context.Type.FUNCTION) {
                --n;
            }
            cptr = cptr.getParent();
        }
        while (!cptr.isTopLevel() && cptr.getType() != Context.Type.FUNCTION) {
            cptr = cptr.getParent();
        }
        Environment s = cptr.getCallingEnvironment();
        if (s == cptr.getGlobalEnvironment()) {
            return 0;
        }
        int j = 0;
        while (true) {
            if (cptr.getType() == Context.Type.FUNCTION) {
                ++j;
                if (cptr.getEnvironment() == s) {
                    n = j;
                }
            }
            if (cptr.isTopLevel()) break;
            cptr = cptr.getParent();
        }
        n = j - n + 1;
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    @Internal(value="sys.frames")
    public static SEXP sysFrames(@Current Context context) {
        Context current = Contexts.findCallingContext(context);
        ArrayList<Environment> environments = new ArrayList<Environment>();
        while (!current.isTopLevel()) {
            if (current.getEnvironment() != Environment.EMPTY) {
                environments.add(current.getEnvironment());
            }
            current = current.getParent();
        }
        ListVector.Builder frames2 = new ListVector.Builder();
        for (int i = environments.size() - 1; i >= 0; --i) {
            frames2.add((SEXP)environments.get(i));
        }
        return frames2.build();
    }

    @Internal(value="sys.frame")
    public static Environment sysFrame(@Current Context context, int which2) {
        if (which2 == 0) {
            return context.getGlobalEnvironment();
        }
        return Contexts.findContext(context, which2).getEnvironment();
    }

    @Internal(value="sys.calls")
    public static PairList sysCalls(@Current Context context) {
        Context current = Contexts.findCallingContext(context);
        AbstractSEXP head = Null.INSTANCE;
        while (!current.isTopLevel()) {
            if (current.getCall() != null) {
                head = new PairList.Node(current.getCall(), (PairList)((Object)head));
            }
            current = current.getParent();
        }
        return head;
    }

    @Internal(value="sys.call")
    public static SEXP sysCall(@Current Context context, int which2) {
        FunctionCall functionCall = Contexts.findContext(context, which2).getCall();
        if (functionCall == null) {
            return Null.INSTANCE;
        }
        return functionCall;
    }

    @Internal(value="sys.function")
    public static SEXP sysFunction(@Current Context context, int which2) {
        return Contexts.findContext(context, which2).getFunction();
    }

    private static Context findContext(@Current Context callingContext, int which2) {
        callingContext = Contexts.findCallingContext(callingContext);
        int n = which2 > 0 ? callingContext.getFrameDepth() - which2 : -which2;
        if (n < 0 || n > callingContext.getFrameDepth() + 1) {
            throw new EvalException("not that many frames on the stack", new Object[0]);
        }
        Context whichContext = callingContext;
        while (n > 0) {
            whichContext = whichContext.getParent();
            --n;
        }
        return whichContext;
    }

    public static Context findCallingContext(Context context) {
        Environment callingEnvironment = context.getCallingEnvironment();
        return Contexts.findCallingContext(context, callingEnvironment);
    }

    public static Context findCallingContext(Context context, Environment callingEnvironment) {
        while (!context.isTopLevel() && context.getEnvironment() != callingEnvironment) {
            context = context.getParent();
        }
        return context;
    }
}

