/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.optimize;

import java.util.ArrayList;
import java.util.List;
import org.renjin.pipeliner.DeferredGraph;
import org.renjin.pipeliner.node.DeferredNode;
import org.renjin.pipeliner.node.FunctionNode;
import org.renjin.pipeliner.optimize.AggregationRecycler;
import org.renjin.pipeliner.optimize.IdentityRemover;
import org.renjin.pipeliner.optimize.Optimizer;
import org.renjin.pipeliner.optimize.SquareOptimizer;
import org.renjin.repackaged.guava.collect.Lists;

public class Optimizers {
    List<Optimizer> optimizers = Lists.newArrayList();

    public Optimizers() {
        if (System.getProperty("renjin.vp.disableopt") == null) {
            this.optimizers.add(new SquareOptimizer());
            this.optimizers.add(new IdentityRemover());
            this.optimizers.add(new AggregationRecycler());
        } else {
            System.err.println("Optimizers are disabled");
        }
    }

    public void optimize(DeferredGraph graph) {
        boolean changed;
        do {
            changed = false;
            ArrayList<DeferredNode> nodes = Lists.newArrayList(graph.getNodes());
            for (DeferredNode node : nodes) {
                if (!(node instanceof FunctionNode)) continue;
                FunctionNode computationNode = (FunctionNode)node;
                for (Optimizer optimizer : this.optimizers) {
                    changed |= optimizer.optimize(graph, computationNode);
                }
            }
        } while (changed);
    }
}

