/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.logging.Logger;
import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.VectorPipeliner;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Vector;

public class VirtualVectorNode
extends LoopNode {
    private static final Logger LOGGER = Logger.getLogger(VirtualVectorNode.class.getName());
    private int ptrLocalIndex;
    private String vectorClass;
    private int operandIndex;
    private Vector.Type vectorType;

    public VirtualVectorNode(int operandIndex, Vector vector2) {
        if (VectorPipeliner.DEBUG) {
            System.out.println("VirtualAccessor for " + vector2.getClass().getName());
        }
        this.vectorType = vector2.getVectorType();
        if (!Modifier.isPublic(vector2.getClass().getModifiers())) {
            LOGGER.warning("Vector class " + vector2.getClass().getName() + " is not public: member access may not be fully inlined by JVM.");
        }
        this.vectorClass = this.findFirstPublicSuperClass(vector2.getClass()).getName().replace('.', '/');
        this.operandIndex = operandIndex;
    }

    private Class findFirstPublicSuperClass(Class clazz) {
        while (!Modifier.isPublic(clazz.getModifiers())) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    @Override
    public void init(ComputeMethod method) {
        this.ptrLocalIndex = method.reserveLocal(1);
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, method.getOperandsLocalIndex());
        this.pushIntConstant(mv, this.operandIndex);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, this.vectorClass);
        mv.visitVarInsn(58, this.ptrLocalIndex);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.ptrLocalIndex);
        mv.visitMethodInsn(182, this.vectorClass, "length", "()I");
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.ptrLocalIndex);
        mv.visitInsn(95);
        mv.visitMethodInsn(182, this.vectorClass, "getElementAsDouble", "(I)D");
    }

    @Override
    public void pushElementAsInt(ComputeMethod method, Optional<Label> naLabel) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.ptrLocalIndex);
        mv.visitInsn(95);
        mv.visitMethodInsn(182, this.vectorClass, "getElementAsInt", "(I)I");
        this.doIntegerNaCheck(mv, naLabel);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return this.vectorType == IntVector.VECTOR_TYPE;
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append(this.vectorClass);
    }
}

