/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import java.util.Optional;
import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.primitives.sequence.IntSequence;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;

public class IntSeqNode
extends LoopNode {
    private static final String SEQUENCE_CLASS = Type.getInternalName(IntSequence.class);
    private int operandIndex;
    private int fromVar;
    private int byVar;
    private int lengthVar;

    public IntSeqNode(int operandIndex) {
        this.operandIndex = operandIndex;
    }

    @Override
    public void init(ComputeMethod method) {
        this.fromVar = method.reserveLocal(1);
        this.byVar = method.reserveLocal(1);
        this.lengthVar = method.reserveLocal(1);
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, method.getOperandsLocalIndex());
        this.pushIntConstant(mv, this.operandIndex);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, SEQUENCE_CLASS);
        mv.visitInsn(89);
        mv.visitMethodInsn(182, SEQUENCE_CLASS, "getFrom", "()I", false);
        mv.visitVarInsn(54, this.fromVar);
        mv.visitInsn(89);
        mv.visitMethodInsn(182, SEQUENCE_CLASS, "getBy", "()I", false);
        mv.visitVarInsn(54, this.byVar);
        mv.visitMethodInsn(182, SEQUENCE_CLASS, "length", "()I", false);
        mv.visitVarInsn(54, this.lengthVar);
    }

    @Override
    public void pushElementAsInt(ComputeMethod method, Optional<Label> naLabel) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(21, this.byVar);
        mv.visitInsn(104);
        mv.visitVarInsn(21, this.fromVar);
        mv.visitInsn(96);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return false;
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append("ISN");
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        this.pushElementAsInt(method, integerNaLabel);
        method.getVisitor().visitInsn(135);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        method.getVisitor().visitVarInsn(21, this.lengthVar);
    }

    public String toString() {
        return "x" + this.operandIndex;
    }
}

