/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import java.util.Optional;
import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;

public class DistanceMatrixNode
extends LoopNode {
    private LoopNode operandNode;
    private int indexTempLocal;
    private int rowTempLocal;
    private int colTempLocal;

    public DistanceMatrixNode(LoopNode operandNode) {
        this.operandNode = operandNode;
    }

    @Override
    public void init(ComputeMethod method) {
        this.operandNode.init(method);
        this.indexTempLocal = method.reserveLocal(1);
        this.rowTempLocal = method.reserveLocal(1);
        this.colTempLocal = method.reserveLocal(1);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        this.operandNode.pushLength(method);
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitInsn(104);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return this.operandNode.mustCheckForIntegerNAs();
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append("DMN");
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.indexTempLocal);
        this.operandNode.pushLength(method);
        mv.visitInsn(112);
        mv.visitVarInsn(54, this.rowTempLocal);
        mv.visitVarInsn(21, this.indexTempLocal);
        this.operandNode.pushLength(method);
        mv.visitInsn(108);
        mv.visitVarInsn(54, this.colTempLocal);
        mv.visitVarInsn(21, this.rowTempLocal);
        this.operandNode.pushElementAsDouble(method, integerNaLabel);
        mv.visitVarInsn(21, this.colTempLocal);
        this.operandNode.pushElementAsDouble(method, integerNaLabel);
        mv.visitInsn(103);
        mv.visitMethodInsn(184, "java/lang/Math", "abs", "(D)D", false);
    }

    public String toString() {
        return "dist(" + this.operandNode + ")";
    }
}

