/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion;

import java.util.HashMap;
import java.util.Map;
import org.renjin.pipeliner.fusion.kernel.ColSumKernel;
import org.renjin.pipeliner.fusion.kernel.LoopKernel;
import org.renjin.pipeliner.fusion.kernel.RowMeanKernel;
import org.renjin.pipeliner.fusion.kernel.SumMeanKernel;
import org.renjin.pipeliner.node.DeferredNode;
import org.renjin.pipeliner.node.FunctionNode;

public enum LoopKernels {
    INSTANCE;

    private Map<String, LoopKernel> map = new HashMap<String, LoopKernel>();

    private LoopKernels() {
        if (System.getProperty("renjin.vp.disablejit") == null) {
            this.map.put("mean", SumMeanKernel.mean());
            this.map.put("sum", SumMeanKernel.sum());
            this.map.put("rowMeans", new RowMeanKernel());
            this.map.put("colSums", new ColSumKernel());
        } else {
            System.err.println("Specializers are disabled");
        }
    }

    public boolean supports(DeferredNode node) {
        if (node instanceof FunctionNode) {
            return this.map.containsKey(((FunctionNode)node).getComputationName());
        }
        return false;
    }

    public LoopKernel get(FunctionNode node) {
        return this.map.get(node.getComputationName());
    }
}

