/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.packaging;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.renjin.eval.Context;
import org.renjin.packaging.SerializedPromise;
import org.renjin.primitives.io.serialization.RDataWriter;
import org.renjin.repackaged.guava.io.Files;
import org.renjin.sexp.Environment;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class LazyLoadFrameBuilder {
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private File outputDir;
    private Context context;
    private Predicate<SEXP> filter = x -> true;
    private Set<String> excludedSymbols = Collections.emptySet();

    public LazyLoadFrameBuilder(Context context) {
        this.context = context;
    }

    public LazyLoadFrameBuilder outputTo(File dir2) {
        this.outputDir = dir2;
        return this;
    }

    public LazyLoadFrameBuilder filter(Predicate<SEXP> filter) {
        this.filter = filter;
        return this;
    }

    public LazyLoadFrameBuilder excludeSymbols(Set<String> excludedSymbols) {
        this.excludedSymbols = excludedSymbols;
        return this;
    }

    public void build(Environment env2) throws IOException {
        File indexFile = new File(this.outputDir, "environment");
        try (DataOutputStream indexOut = new DataOutputStream(new FileOutputStream(indexFile));){
            indexOut.writeInt(2);
            ArrayList<Symbol> symbols = new ArrayList<Symbol>();
            for (Symbol symbol2 : env2.getFrame().getSymbols()) {
                SEXP value;
                if (this.excludedSymbols.contains(symbol2.getPrintName()) || !this.filter.test(value = env2.getFrame().getVariable(symbol2))) continue;
                symbols.add(symbol2);
            }
            indexOut.writeInt(symbols.size());
            for (Symbol symbol2 : symbols) {
                SEXP variable = env2.getFrame().getVariable(symbol2);
                indexOut.writeUTF(symbol2.getPrintName());
                byte[] bytes = this.serializeSymbol(variable);
                if (bytes.length > 1024) {
                    indexOut.writeInt(-1);
                    Files.write(bytes, new File(this.outputDir, SerializedPromise.resourceName(symbol2.getPrintName())));
                    continue;
                }
                indexOut.writeInt(bytes.length);
                indexOut.write(bytes);
            }
        }
    }

    private byte[] serializeSymbol(SEXP value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDataWriter writer = new RDataWriter(this.context, (OutputStream)baos);
        writer.serialize(value);
        baos.close();
        return baos.toByteArray();
    }
}

