/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.math.Errors;
import org.renjin.nmath.rbinom;

public class rmultinom {
    private rmultinom() {
    }

    public static void rmultinom(MethodHandle methodHandle, int n, Ptr ptr, int n2, Ptr ptr2) {
        block11: {
            double d = 0.0;
            if (n2 > 0) {
                if (n < 0) {
                    ptr2.setInt(-1);
                } else {
                    double d2;
                    int n3 = 0;
                    while (n3 < n2) {
                        d2 = ptr.getDouble(n3 * 8);
                        if (Builtins.__finite(d2) == 0 || d2 < 0.0 || d2 > 1.0) {
                            ptr2.setInt(n3 * 4, -1);
                            break block11;
                        }
                        d += d2;
                        ptr2.setInt(n3 * 4, 0);
                        ++n3;
                    }
                    if (Math.abs(d - 1.0) > 1.0E-7) {
                        Errors.arith_error(new BytePtr("rbinom: probability sum should be 1, but is %g\u0000".getBytes(), 0), d);
                    }
                    if (n != 0 && (n2 != 1 || d != 0.0)) {
                        int n4 = 0;
                        while (n2 + -1 > n4) {
                            if (ptr.getDouble(n4 * 8) != 0.0) {
                                d2 = ptr.getDouble(n4 * 8) / d;
                                n3 = n4 * 4;
                                int n5 = d2 < 1.0 ? (int)rbinom.rbinom(methodHandle, n, d2) : n;
                                ptr2.setInt(n3, n5);
                                n -= ptr2.getInt(n4 * 4);
                            } else {
                                ptr2.setInt(n4 * 4, 0);
                            }
                            if (n > 0) {
                                d -= ptr.getDouble(n4 * 8);
                                ++n4;
                                continue;
                            }
                            break block11;
                        }
                        ptr2.setInt((n2 + -1) * 4, n);
                    }
                }
            }
        }
    }
}

