/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.math;

import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.math.dlamch__;

public class dlasv2__ {
    private dlasv2__() {
    }

    public static void dlasv2_(Ptr f, Ptr g, Ptr h, Ptr ssmin, Ptr ssmax, Ptr snr, Ptr csr, Ptr snl, Ptr csl) {
        boolean swap;
        double tsign = 0.0;
        double srt = 0.0;
        double slt = 0.0;
        double crt = 0.0;
        double clt = 0.0;
        double ft = f.getDouble();
        double fa = Math.abs(ft);
        double ht = h.getDouble();
        double ha = Math.abs(h.getDouble());
        int pmax2 = 1;
        boolean bl = swap = ha > fa;
        if (swap) {
            pmax2 = 3;
            double temp = ft;
            ft = ht;
            ht = temp;
            temp = fa;
            fa = ha;
            ha = temp;
        }
        double gt = g.getDouble();
        double ga = Math.abs(gt);
        if (ga == 0.0) {
            ssmin.setDouble(ha);
            ssmax.setDouble(fa);
            clt = 1.0;
            crt = 1.0;
            slt = 0.0;
            srt = 0.0;
        } else {
            boolean gasmal = true;
            if (ga > fa) {
                pmax2 = 2;
                double d = fa / ga;
                double d2 = dlamch__.dlamch_(new BytePtr("EPS".getBytes(), 0), 3);
                if (d < d2) {
                    gasmal = false;
                    ssmax.setDouble(ga);
                    if (ha > 1.0) {
                        double d3 = ga / ha;
                        double d4 = fa / d3;
                        ssmin.setDouble(d4);
                    } else {
                        double d5 = fa / ga * ha;
                        ssmin.setDouble(d5);
                    }
                    clt = 1.0;
                    slt = ht / gt;
                    srt = 1.0;
                    crt = ft / gt;
                }
            }
            if (gasmal) {
                double r;
                double d = fa - ha;
                double l = d == fa ? 1.0 : d / fa;
                double m = gt / ft;
                double t2 = 2.0 - l;
                double d6 = m;
                double mm = d6 * d6;
                double d7 = t2;
                double s = Mathlib.sqrt(d7 * d7 + mm);
                if (l == 0.0) {
                    r = Math.abs(m);
                } else {
                    double d8 = l;
                    r = Mathlib.sqrt(d8 * d8 + mm);
                }
                double a = (s + r) * 0.5;
                double d9 = ha / a;
                ssmin.setDouble(d9);
                double d10 = fa * a;
                ssmax.setDouble(d10);
                if (mm == 0.0) {
                    if (l == 0.0) {
                        double d11 = Mathlib.copysign(2.0, ft);
                        double d12 = Mathlib.copysign(1.0, gt);
                        t2 = d11 * d12;
                    } else {
                        double d13 = Mathlib.copysign(d, ft);
                        double d14 = gt / d13;
                        double d15 = m / t2;
                        t2 = d14 + d15;
                    }
                } else {
                    double d16 = s + t2;
                    double d17 = m / d16;
                    double d18 = r + l;
                    double d19 = m / d18;
                    double d20 = d17 + d19;
                    double d21 = a + 1.0;
                    t2 = d20 * d21;
                }
                double d22 = t2;
                l = Mathlib.sqrt(d22 * d22 + 4.0);
                crt = 2.0 / l;
                srt = t2 / l;
                clt = (srt * m + crt) / a;
                slt = ht / ft * srt / a;
            }
        }
        if (swap) {
            csl.setDouble(srt);
            snl.setDouble(crt);
            csr.setDouble(slt);
            snr.setDouble(clt);
        } else {
            csl.setDouble(clt);
            snl.setDouble(slt);
            csr.setDouble(crt);
            snr.setDouble(srt);
        }
        if (pmax2 == 1) {
            double d = csr.getDouble();
            double d23 = Mathlib.copysign(1.0, d);
            double d24 = csl.getDouble();
            double d25 = Mathlib.copysign(1.0, d24);
            double d26 = d23 * d25;
            double d27 = f.getDouble();
            double d28 = Mathlib.copysign(1.0, d27);
            tsign = d26 * d28;
        }
        if (pmax2 == 2) {
            double d = snr.getDouble();
            double d29 = Mathlib.copysign(1.0, d);
            double d30 = csl.getDouble();
            double d31 = Mathlib.copysign(1.0, d30);
            double d32 = d29 * d31;
            double d33 = g.getDouble();
            double d34 = Mathlib.copysign(1.0, d33);
            tsign = d32 * d34;
        }
        if (pmax2 == 3) {
            double d = snr.getDouble();
            double d35 = Mathlib.copysign(1.0, d);
            double d36 = snl.getDouble();
            double d37 = Mathlib.copysign(1.0, d36);
            double d38 = d35 * d37;
            double d39 = h.getDouble();
            double d40 = Mathlib.copysign(1.0, d39);
            tsign = d38 * d40;
        }
        double d = Mathlib.copysign(ssmax.getDouble(), tsign);
        ssmax.setDouble(d);
        double d41 = f.getDouble();
        double d42 = Mathlib.copysign(1.0, d41) * tsign;
        double d43 = h.getDouble();
        double d44 = Mathlib.copysign(1.0, d43);
        double d45 = d42 * d44;
        double d46 = Mathlib.copysign(ssmin.getDouble(), d45);
        ssmin.setDouble(d46);
    }
}

