/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.special.Gamma;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Cast;
import org.renjin.invoke.annotations.CastStyle;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.DefaultValue;
import org.renjin.invoke.annotations.Deferrable;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.GroupGeneric;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Invisible;
import org.renjin.invoke.annotations.InvokeAsCharacter;
import org.renjin.invoke.annotations.NamedFlag;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.invoke.annotations.Unevaluated;
import org.renjin.invoke.model.FriendlyTypesNames;
import org.renjin.repackaged.guava.collect.ImmutableList;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Logical;
import org.renjin.sexp.Symbol;

public class JvmMethod
implements Comparable<JvmMethod> {
    private Method method;
    private List<Argument> arguments;
    private List<Argument> formals;
    private boolean dataParallel;
    private boolean passNA;
    private static final Class[] ATOMIC_TYPES = new Class[]{Boolean.TYPE, Boolean.class, Logical.class, Integer.TYPE, Integer.class, Double.TYPE, Double.class, Complex.class, String.class, Byte.class, Byte.TYPE};

    public JvmMethod(Method method) {
        this.method = method;
        ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
        for (int i = 0; i != method.getParameterTypes().length; ++i) {
            argumentsBuilder.add(new Argument(method, i));
        }
        this.arguments = argumentsBuilder.build();
        this.formals = this.arguments.stream().filter(arg -> !arg.isContextual()).collect(Collectors.toList());
        DataParallel dpAnnotation = method.getAnnotation(DataParallel.class);
        boolean bl = this.dataParallel = dpAnnotation != null || method.getDeclaringClass().equals(Math.class) || method.getDeclaringClass().equals(Gamma.class);
        if (this.dataParallel) {
            this.passNA = dpAnnotation != null && dpAnnotation.passNA();
            boolean implicitRecycling = this.isArgumentRecyclingImplicit();
            for (Argument arg2 : this.formals) {
                Recycle recycleAnnotation = arg2.getAnnotation(Recycle.class);
                arg2.recycle = arg2.isAtomicElementType() && (implicitRecycling || recycleAnnotation == null || recycleAnnotation.value());
            }
        }
    }

    private boolean isArgumentRecyclingImplicit() {
        for (Argument formal : this.formals) {
            if (formal.getAnnotation(Recycle.class) == null) continue;
            return false;
        }
        return true;
    }

    public static List<JvmMethod> findOverloads(Class clazz, String name, String alias) {
        ArrayList<JvmMethod> methods = Lists.newArrayList();
        if (clazz != null) {
            for (Method method : clazz.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || !method.getName().equals(alias) && !method.getName().equals(name) && !JvmMethod.alias(method).equals(name)) continue;
                methods.add(new JvmMethod(method));
            }
        }
        JvmMethod.validate(methods);
        return methods;
    }

    public static String alias(Method method) {
        Builtin builtin = method.getAnnotation(Builtin.class);
        if (builtin != null) {
            return builtin.value();
        }
        Internal internal = method.getAnnotation(Internal.class);
        if (internal != null) {
            return internal.value();
        }
        return "";
    }

    public boolean acceptsArgumentList() {
        for (Argument formal : this.formals) {
            if (!formal.isAnnotatedWith(ArgumentList.class)) continue;
            return true;
        }
        return false;
    }

    public boolean isDataParallel() {
        return this.dataParallel;
    }

    public boolean isStrict() {
        for (Argument formal : this.getFormals()) {
            if (formal.isEvaluated() || formal.isSymbol()) continue;
            return false;
        }
        return true;
    }

    public boolean isGeneric() {
        return this.method.getAnnotation(Generic.class) != null || this.method.getDeclaringClass().getAnnotation(GroupGeneric.class) != null;
    }

    public boolean isGroupGeneric() {
        return this.method.getDeclaringClass().getAnnotation(GroupGeneric.class) != null || this.method.getAnnotation(GroupGeneric.class) != null;
    }

    public String getGenericGroup() {
        GroupGeneric annotation = this.method.getAnnotation(GroupGeneric.class);
        if (annotation == null) {
            annotation = this.method.getDeclaringClass().getAnnotation(GroupGeneric.class);
        }
        if (annotation == null) {
            throw new IllegalStateException(this.getName() + " is not a @GroupGeneric");
        }
        if (!annotation.value().isEmpty()) {
            return annotation.value();
        }
        return this.method.getDeclaringClass().getSimpleName();
    }

    public PreserveAttributeStyle getPreserveAttributesStyle() {
        DataParallel annotation = this.method.getAnnotation(DataParallel.class);
        return annotation == null ? PreserveAttributeStyle.STRUCTURAL : annotation.value();
    }

    public String getGenericName() {
        Builtin primitive2 = this.method.getAnnotation(Builtin.class);
        if (primitive2 != null && primitive2.value() != null) {
            return primitive2.value();
        }
        return this.method.getName();
    }

    public List<Argument> getAllArguments() {
        return this.arguments;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class getDeclaringClass() {
        return this.method.getDeclaringClass();
    }

    public Class getReturnType() {
        return this.method.getReturnType();
    }

    public boolean returnsVoid() {
        return this.method.getReturnType() == Void.class || this.method.getReturnType() == Void.TYPE;
    }

    public String getName() {
        return this.method.getName();
    }

    public int countPositionalFormals() {
        return this.getPositionalFormals().size();
    }

    public List<Argument> getPositionalFormals() {
        ArrayList<Argument> list2 = Lists.newArrayList();
        for (Argument formal : this.getFormals()) {
            if (formal.isAnnotatedWith(ArgumentList.class) || formal.isAnnotatedWith(NamedFlag.class)) break;
            list2.add(formal);
        }
        return list2;
    }

    public void appendFriendlySignatureTo(StringBuilder sb) {
        this.appendFriendlySignatureTo(this.method.getName(), sb);
    }

    public void appendFriendlySignatureTo(String name, StringBuilder sb) {
        sb.append(name).append("(");
        boolean needsComma = false;
        for (Argument argument : this.arguments) {
            if (argument.isContextual()) continue;
            if (needsComma) {
                sb.append(", ");
            } else {
                needsComma = true;
            }
            if (argument.isAnnotatedWith(ArgumentList.class)) {
                sb.append("...");
                continue;
            }
            sb.append(FriendlyTypesNames.get().format(argument.getClazz()));
            if (argument.isRecycle() || !argument.isAtomicElementType()) continue;
            sb.append("(1)");
        }
        sb.append(")");
    }

    public List<Argument> getFormals() {
        return this.formals;
    }

    public boolean isHiddenBy(JvmMethod other) {
        if (this.formals.size() != other.getFormals().size()) {
            return false;
        }
        for (int i = 0; i != this.formals.size(); ++i) {
            if (this.formals.get(i).getClazz().isAssignableFrom(other.getFormals().get(i).getClazz())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(JvmMethod o) {
        if (this.formals.size() != o.getFormals().size()) {
            return this.formals.size() - o.getFormals().size();
        }
        if (this.isHiddenBy(o)) {
            return -1;
        }
        if (o.isHiddenBy(this)) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.method.toString();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotationClass) {
        return this.method.isAnnotationPresent(annotationClass);
    }

    public boolean isDeferrable() {
        return this.isAnnotatedWith(Deferrable.class) || this.method.getDeclaringClass().equals(Math.class);
    }

    public boolean isPassNA() {
        return this.passNA;
    }

    public boolean isInvisible() {
        return this.isAnnotatedWith(Invisible.class);
    }

    public boolean isPure() {
        for (Argument argument : this.getAllArguments()) {
            if (!argument.isContextual()) continue;
            return false;
        }
        return true;
    }

    public static void validate(List<JvmMethod> methods) {
        for (int i = 0; i != methods.size(); ++i) {
            for (int j = 0; j != methods.size(); ++j) {
                JvmMethod y;
                JvmMethod x;
                if (i == j || !(x = methods.get(i)).isHiddenBy(y = methods.get(j))) continue;
                throw new EvalException(JvmMethod.formatHiddenMethod(x, y), new Object[0]);
            }
        }
    }

    private static String formatHiddenMethod(JvmMethod x, JvmMethod y) {
        StringBuilder sb = new StringBuilder();
        sb.append("Primitive method\n\t");
        x.appendFriendlySignatureTo(sb);
        sb.append("\nis hidden by\n\t");
        y.appendFriendlySignatureTo(sb);
        return sb.append("\n").toString();
    }

    private boolean isAtomic(Class clazz) {
        for (int i = 0; i != ATOMIC_TYPES.length; ++i) {
            if (!clazz.equals(ATOMIC_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    public class Argument {
        private int index;
        private Class clazz;
        private boolean contextual = false;
        private boolean evaluated = true;
        private boolean symbol;
        private String name;
        public boolean recycle;
        public boolean atomicType;
        public boolean defaultValue;

        public Argument(Method method, int index) {
            this.clazz = method.getParameterTypes()[index];
            this.index = index;
            for (Annotation annotation : method.getParameterAnnotations()[index]) {
                if (annotation instanceof Current) {
                    this.contextual = true;
                    continue;
                }
                if (annotation instanceof Unevaluated) {
                    this.evaluated = false;
                    continue;
                }
                if (annotation instanceof NamedFlag) {
                    this.name = ((NamedFlag)annotation).value();
                    continue;
                }
                if (annotation instanceof DefaultValue) {
                    this.defaultValue = ((DefaultValue)annotation).value();
                    continue;
                }
                if (!(annotation instanceof InvokeAsCharacter)) continue;
                this.evaluated = true;
            }
            this.symbol = this.clazz == Symbol.class;
            this.atomicType = JvmMethod.this.isAtomic(this.clazz);
        }

        public boolean isAnnotatedWith(Class<? extends Annotation> annotationClass) {
            for (Annotation annotation : JvmMethod.this.method.getParameterAnnotations()[this.index]) {
                if (annotation.annotationType() != annotationClass) continue;
                return true;
            }
            return false;
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            for (Annotation annotation : JvmMethod.this.method.getParameterAnnotations()[this.index]) {
                if (annotation.annotationType() != annotationClass) continue;
                return (T)annotation;
            }
            return null;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public boolean isContextual() {
            return this.contextual;
        }

        public boolean isEvaluated() {
            return this.evaluated;
        }

        public boolean isSymbol() {
            return this.symbol;
        }

        public boolean isAtomicElementType() {
            return this.atomicType;
        }

        public boolean isRecycle() {
            return this.recycle;
        }

        public boolean hasName() {
            return this.name != null;
        }

        public String getName() {
            return this.name;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isVarArg() {
            return this.isAnnotatedWith(ArgumentList.class);
        }

        public boolean isNamedFlag() {
            return this.isAnnotatedWith(NamedFlag.class);
        }

        public CastStyle getCastStyle() {
            Cast cast = this.getAnnotation(Cast.class);
            if (cast == null) {
                return CastStyle.IMPLICIT;
            }
            return cast.value();
        }
    }
}

