/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.io.IOException;
import org.renjin.eval.Context;
import org.renjin.invoke.codegen.ApplyArrayArgsMethodBuilder;
import org.renjin.invoke.codegen.FixedArityApplyBuilder;
import org.renjin.invoke.codegen.GeneratorDefinitionException;
import org.renjin.invoke.codegen.OverloadWrapperBuilder;
import org.renjin.invoke.codegen.VarArgApplyBuilder;
import org.renjin.invoke.codegen.WrapperGenerator2;
import org.renjin.invoke.model.PrimitiveModel;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;

public class InvokerGenerator {
    private final JCodeModel codeModel;

    public InvokerGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    public final void generate(PrimitiveModel model) throws JClassAlreadyExistsException, IOException {
        JDefinedClass invoker = this.codeModel._class(WrapperGenerator2.toFullJavaName(model.getName()));
        if (model.isSpecial()) {
            invoker._extends(SpecialFunction.class);
        } else {
            invoker._extends(BuiltinFunction.class);
        }
        JMethod defaultConstructor = invoker.constructor(1);
        defaultConstructor.body().invoke("super").arg(JExpr.lit(model.getName()));
        if (model.hasVargs() && model.getOverloads().size() > 1) {
            throw new GeneratorDefinitionException(model.getName() + ": If var args are used, multiple overloads cannot be used");
        }
        if (model.hasVargs()) {
            VarArgApplyBuilder apply = new VarArgApplyBuilder(this.codeModel, invoker, model);
            apply.build();
            ApplyArrayArgsMethodBuilder applyWithArray = new ApplyArrayArgsMethodBuilder(this.codeModel, invoker, model);
            applyWithArray.buildVarArgs();
            this.addArrayApplyOverload(invoker);
        } else {
            FixedArityApplyBuilder apply = new FixedArityApplyBuilder(this.codeModel, invoker, model);
            apply.build();
            ApplyArrayArgsMethodBuilder applyWithArray = new ApplyArrayArgsMethodBuilder(this.codeModel, invoker, model);
            applyWithArray.build();
            this.addArrayApplyOverload(invoker);
            for (Integer arity : model.getArity()) {
                OverloadWrapperBuilder doApply = new OverloadWrapperBuilder(this.codeModel, invoker, model, arity);
                doApply.build();
            }
        }
    }

    private void addArrayApplyOverload(JDefinedClass invoker) {
        JMethod method = invoker.method(1, SEXP.class, "apply");
        JVar context = method.param(Context.class, "context");
        JVar environment2 = method.param(Environment.class, "environment");
        JVar call2 = method.param(FunctionCall.class, "call");
        JVar argNames = method.param(String[].class, "argNames");
        JVar args2 = method.param(SEXP[].class, "args");
        method.body()._return(invoker.staticInvoke("doApply").arg(context).arg(environment2).arg(call2).arg(argNames).arg(args2));
    }
}

