/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ApplyMethodContext;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.codegen.ExceptionWrapper;
import org.renjin.invoke.codegen.generic.GenericDispatchStrategy;
import org.renjin.invoke.codegen.generic.GroupDispatchStrategy;
import org.renjin.invoke.codegen.generic.MatrixMultDispatchStrategy;
import org.renjin.invoke.codegen.generic.OpsGroupGenericDispatchStrategy;
import org.renjin.invoke.codegen.generic.SimpleDispatchStrategy;
import org.renjin.invoke.codegen.generic.SummaryGroupGenericStrategy;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.invoke.model.PrimitiveModel;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;

public abstract class ApplyMethodBuilder
implements ApplyMethodContext {
    protected JCodeModel codeModel;
    protected JDefinedClass invoker;
    protected JVar context;
    protected JVar environment;
    protected JVar call;
    protected JVar args;
    protected PrimitiveModel primitive;
    protected JMethod method;
    protected JVar argumentIterator;
    protected GenericDispatchStrategy genericDispatchStrategy;

    public ApplyMethodBuilder(JCodeModel codeModel, JDefinedClass invoker, PrimitiveModel primitive2) {
        this.codeModel = codeModel;
        this.invoker = invoker;
        this.primitive = primitive2;
        this.genericDispatchStrategy = this.genericDispatchStrategy(primitive2);
    }

    public void build() {
        this.declareMethod();
        ExceptionWrapper mainTryBlock = new ExceptionWrapper(this.codeModel, this.method.body(), this.context);
        this.catchArgumentExceptions(mainTryBlock);
        mainTryBlock.catchEvalExceptions();
        mainTryBlock.catchRuntimeExceptions();
        mainTryBlock.catchExceptions();
        this.argumentIterator = mainTryBlock.body().decl(this.classRef(ArgumentIterator.class), "argIt", JExpr._new(this.classRef(ArgumentIterator.class)).arg(this.context).arg(this.environment).arg(this.args));
        this.apply(mainTryBlock.body());
    }

    @Override
    public JClass classRef(Class<?> clazz) {
        return this.codeModel.ref(clazz);
    }

    @Override
    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    protected void declareMethod() {
        this.method = this.invoker.method(1, SEXP.class, "apply");
        this.context = this.method.param(Context.class, "context");
        this.environment = this.method.param(Environment.class, "environment");
        this.call = this.method.param(FunctionCall.class, "call");
        this.args = this.method.param(PairList.class, "args");
    }

    protected void apply(JBlock parent2) {
    }

    protected JExpression nextArgAsSexp(boolean evaluated) {
        if (evaluated) {
            return JExpr.invoke((JExpression)this.argumentIterator, "evalNext");
        }
        return JExpr.invoke((JExpression)this.argumentIterator, "next");
    }

    public void catchArgumentExceptions(ExceptionWrapper mainTryBlock) {
        JCatchBlock catchBlock = mainTryBlock._catch((JClass)this.codeModel._ref(ArgumentException.class));
        JVar e = catchBlock.param("e");
        catchBlock.body()._throw(JExpr._new(this.codeModel._ref(EvalException.class)).arg(this.context).arg(JExpr.lit(this.primitive.argumentErrorMessage())).arg(e.invoke("getMessage")));
    }

    private GenericDispatchStrategy genericDispatchStrategy(PrimitiveModel primitive2) {
        JvmMethod overload = primitive2.getOverloads().get(0);
        if (primitive2.getName().equals("%*%")) {
            return new MatrixMultDispatchStrategy(this.codeModel);
        }
        if (overload.isGroupGeneric()) {
            if (overload.getGenericGroup().equals("Ops")) {
                return new OpsGroupGenericDispatchStrategy(this.codeModel, primitive2.getName());
            }
            if (overload.getGenericGroup().equals("Summary")) {
                return new SummaryGroupGenericStrategy(this.codeModel, primitive2.getName());
            }
            return new GroupDispatchStrategy(this.codeModel, overload.getGenericGroup(), primitive2.getName());
        }
        if (overload.isGeneric()) {
            return new SimpleDispatchStrategy(this.codeModel, primitive2.getName());
        }
        return new GenericDispatchStrategy(this.codeModel);
    }

    @Override
    public JExpression getContext() {
        return this.context;
    }

    @Override
    public JExpression getEnvironment() {
        return this.environment;
    }
}

