/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.util.concurrent.atomic.AtomicBoolean;
import org.renjin.grDevices.GDObject;
import org.renjin.grDevices.GDState;

public class AwtPanel
extends Panel {
    private final int bufferWidth;
    private final int bufferHeight;
    private boolean forceAntiAliasing;
    private transient Image bufferImage;
    private transient Graphics bufferGraphics;
    private transient boolean paused = false;
    private AtomicBoolean pendingPaint = new AtomicBoolean(false);

    AwtPanel(Dimension size) {
        this.setSize(size);
        this.bufferWidth = (int)size.getWidth();
        this.bufferHeight = (int)size.getHeight();
    }

    public void setForceAntiAliasing(boolean forceAntiAliasing) {
        this.forceAntiAliasing = forceAntiAliasing;
    }

    private void initBuffer() {
        this.bufferImage = this.createImage(this.bufferWidth, this.bufferHeight);
        if (this.bufferImage == null) {
            throw new IllegalStateException("null buffer image");
        }
        this.bufferGraphics = this.bufferImage.getGraphics();
        if (this.forceAntiAliasing && this.bufferGraphics instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)this.bufferGraphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.resetBuffer();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.pendingPaint.set(false);
        g.drawImage(this.bufferImage, 0, 0, this);
    }

    public void paint(GDObject o, GDState state) {
        if (this.bufferImage == null) {
            this.initBuffer();
        }
        o.paint(this, state, this.bufferGraphics);
        if (!this.paused) {
            this.scheduleRepaint();
        }
    }

    public Graphics getBufferGraphics() {
        return this.bufferGraphics;
    }

    public void reset() {
        this.resetBuffer();
        this.scheduleRepaint();
    }

    private void scheduleRepaint() {
        if (this.pendingPaint.compareAndSet(false, true)) {
            this.repaint();
        }
    }

    private void resetBuffer() {
        if (this.bufferGraphics != null) {
            this.bufferGraphics.clearRect(0, 0, this.bufferWidth, this.bufferHeight);
        }
    }

    public void setRepaintPaused(boolean paused) {
        this.paused = paused;
        if (!paused) {
            this.scheduleRepaint();
        }
    }
}

