/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.reflect.Field;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;

public class LongFieldPtr
extends AbstractPtr {
    private final Field field;

    public static Ptr addressOf(Class declaringClass, String fieldName) {
        try {
            return new LongFieldPtr(declaringClass.getField(fieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public LongFieldPtr(Field field) {
        this.field = field;
    }

    @Override
    public Object getArray() {
        return this.field;
    }

    @Override
    public final int getOffsetInBytes() {
        return 0;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public long getLong() {
        try {
            return this.field.getLong(null);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public void setLong(long value) {
        try {
            this.field.setLong(null, value);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public long getLong(int offset) {
        if (offset == 0) {
            return this.getLong();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setLong(int offset, long intValue) {
        if (offset != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setLong(intValue);
    }

    @Override
    public long getAlignedLong(int index) {
        if (index == 0) {
            return this.getLong();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setAlignedLong(int index, long value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setLong(value);
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaLong(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaLong(offset, value);
    }

    @Override
    public int toInt() {
        return 0;
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

