/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.reflect.Field;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;

public class FloatFieldPtr
extends AbstractPtr {
    private final Field field;

    public static Ptr addressOf(Class declaringClass, String fieldName) {
        try {
            return new FloatFieldPtr(declaringClass.getField(fieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public FloatFieldPtr(Field field) {
        this.field = field;
    }

    @Override
    public Object getArray() {
        return this.field;
    }

    @Override
    public final int getOffsetInBytes() {
        return 0;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public float getFloat() {
        try {
            return this.field.getFloat(null);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public void setFloat(float value) {
        try {
            this.field.setFloat(null, value);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public float getFloat(int offset) {
        if (offset == 0) {
            return this.getFloat();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setFloat(int offset, float intValue) {
        if (offset != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setFloat(intValue);
    }

    @Override
    public float getAlignedFloat(int index) {
        if (index == 0) {
            return this.getFloat();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setAlignedFloat(int index, float value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setFloat(value);
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaFloat(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaFloat(offset, value);
    }

    @Override
    public int toInt() {
        return 0;
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

