/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class BytePtr
extends AbstractPtr {
    public static final BytePtr NULL = new BytePtr();
    public final byte[] array;
    public final int offset;

    private BytePtr() {
        this.array = null;
        this.offset = 0;
    }

    public BytePtr(byte ... array2) {
        this(array2, 0);
    }

    public BytePtr(byte[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public static Ptr of(int value) {
        return NULL.pointerPlus(value);
    }

    public byte get() {
        return this.array[this.offset];
    }

    public void set(byte value) {
        this.array[this.offset] = value;
    }

    public static byte[] toArray(String constant) {
        return constant.getBytes(StandardCharsets.UTF_8);
    }

    public static BytePtr asciiString(String string) {
        return new BytePtr(string.getBytes(StandardCharsets.US_ASCII), 0);
    }

    public static BytePtr nullTerminatedString(String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        byte[] nullTerminatedBytes = Arrays.copyOf(bytes, bytes.length + 1);
        return new BytePtr(nullTerminatedBytes, 0);
    }

    public int nullTerminatedStringLength() {
        for (int i = this.offset; i < this.array.length; ++i) {
            if (this.array[i] != 0) continue;
            return i - this.offset;
        }
        throw new IllegalStateException("String is not null-terminated.");
    }

    public String nullTerminatedString() {
        return new String(this.array, this.offset, this.nullTerminatedStringLength(), StandardCharsets.UTF_8);
    }

    public String toString(int length2) {
        return new String(this.array, this.offset, length2, StandardCharsets.UTF_8);
    }

    public static BytePtr malloc(int bytes) {
        return new BytePtr(new byte[bytes]);
    }

    public static BytePtr fromString(String string) {
        return new BytePtr(string.getBytes(), 0);
    }

    public static void memset(byte[] str, int strOffset, int c2, int n) {
        Arrays.fill(str, strOffset, strOffset + n, (byte)c2);
    }

    public static byte memset(int c2) {
        return (byte)c2;
    }

    public byte[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset;
    }

    @Override
    public BytePtr realloc(int newSizeInBytes) {
        return new BytePtr(Realloc.realloc(this.array, this.offset, newSizeInBytes));
    }

    @Override
    public BytePtr copyOf(int numBytes) {
        return new BytePtr(Arrays.copyOf(this.array, numBytes));
    }

    @Override
    public void memcpy(Ptr source, int numBytes) {
        if (source instanceof BytePtr) {
            BytePtr sourceBytePtr = (BytePtr)source;
            System.arraycopy(sourceBytePtr.array, sourceBytePtr.offset, this.array, this.offset, numBytes);
        } else {
            super.memcpy(source, numBytes);
        }
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new BytePtr(this.array, this.offset + bytes);
    }

    @Override
    public byte getByte(int offset) {
        return this.array[this.offset + offset];
    }

    @Override
    public void setByte(int offset, byte value) {
        this.array[this.offset + offset] = value;
    }

    @Override
    public int toInt() {
        return this.offset;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    public static BytePtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).bytePtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (BytePtr)voidPointer;
    }

    public static int memcmp(BytePtr s1, BytePtr s2, int len) {
        for (int i = 0; i < len; ++i) {
            byte b1 = s1.array[s1.offset + i];
            byte b2 = s2.array[s2.offset + i];
            if (b1 == b2) continue;
            int i1 = b1 & 0xFF;
            int i2 = b2 & 0xFF;
            return i1 - i2;
        }
        return 0;
    }

    public static void memcpy(BytePtr x, BytePtr y, int numBytes) {
        int offsetS;
        byte[] arrayS = y.getArray();
        int restY = arrayS.length - (offsetS = y.getOffset());
        if (restY > 0) {
            byte[] carray = new byte[numBytes];
            int i = 0;
            for (int j = offsetS; j < arrayS.length && i < numBytes; ++j, ++i) {
                carray[i] = arrayS[j];
            }
            x = new BytePtr(carray);
        }
    }
}

