/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval.vfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.zip.ZipFileSystem;
import org.renjin.eval.vfs.FastJarFileObject;
import org.renjin.eval.vfs.FastJarFileProvider;
import org.renjin.eval.vfs.FastJarRootFileObject;
import org.renjin.eval.vfs.NonExistentJarFileObject;
import org.renjin.repackaged.guava.collect.Lists;

public class FastJarFileSystem
extends AbstractFileSystem
implements FileSystem {
    private static final Log log = LogFactory.getLog(ZipFileSystem.class);
    private final File file;
    private boolean exists;
    private JarFile jarFile;
    private NonExistentJarFileObject nonExistentJarFileObject;

    public FastJarFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, parentLayer, fileSystemOptions);
        this.file = parentLayer.getFileSystem().replicateFile(parentLayer, Selectors.SELECT_SELF);
        this.exists = this.file.exists();
        if (this.file.exists()) {
            try {
                this.jarFile = new JarFile(this.file);
            }
            catch (IOException e) {
                throw new FileSystemException((Throwable)e);
            }
        }
    }

    protected void doCloseCommunicationLink() {
        try {
            if (this.jarFile != null) {
                this.jarFile.close();
                this.jarFile = null;
            }
        }
        catch (IOException e) {
            VfsLog.warn((Log)this.getLogger(), (Log)log, (String)("vfs.provider.zip/close-zip-file.error :" + this.file), (Throwable)e);
        }
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(FastJarFileProvider.capabilities);
    }

    private JarFile getJarFile() {
        return this.jarFile;
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        if (!this.exists) {
            return new NonExistentJarFileObject(name, this);
        }
        String entryName = this.getRootName().getRelativeName((FileName)name);
        if (entryName.equals(".")) {
            return new FastJarRootFileObject(name, this);
        }
        JarEntry entry = this.getJarFile().getJarEntry(entryName + "/");
        if (entry != null) {
            return new FastJarFileObject(name, entry, this);
        }
        entry = this.getJarFile().getJarEntry(entryName);
        if (entry == null) {
            return new NonExistentJarFileObject(name, this);
        }
        return new FastJarFileObject(name, entry, this);
    }

    public String[] getRootItems() {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream(JarEntry entry) throws FileSystemException {
        try {
            return this.getJarFile().getInputStream(entry);
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public String[] listChildren(String name) {
        JarFile jarFile = this.getJarFile();
        ArrayList<String> children = Lists.newArrayList();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.getName().equals(name) || !entry.getName().startsWith(name)) continue;
            String childName = entry.getName().substring(name.length());
            int slash = childName.indexOf(47);
            if (slash == -1) {
                children.add(childName);
                continue;
            }
            if (slash != childName.length() - 1) continue;
            children.add(childName.substring(0, childName.length() - 1));
        }
        return children.toArray(new String[children.size()]);
    }
}

