/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.renjin.eval.Context;
import org.renjin.eval.FinalizationHandler;
import org.renjin.eval.FinalizerRegistry;
import org.renjin.eval.Options;
import org.renjin.eval.SecurityManager;
import org.renjin.eval.SessionController;
import org.renjin.pipeliner.VectorPipeliner;
import org.renjin.primitives.Warning;
import org.renjin.primitives.io.connections.ConnectionTable;
import org.renjin.primitives.packaging.DllInfo;
import org.renjin.primitives.packaging.NamespaceRegistry;
import org.renjin.primitives.packaging.PackageLoader;
import org.renjin.repackaged.guava.collect.ImmutableList;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.s4.S4Cache;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Frame;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.stats.internals.distributions.RNG;
import org.renjin.util.FileSystemUtils;

public class Session {
    public static final List<String> DEFAULT_PACKAGES = ImmutableList.of("stats", "graphics", "grDevices", "utils", "datasets", "methods");
    private final Context topLevelContext;
    private S4Cache s4Cache = new S4Cache();
    private FinalizerRegistry finalizers = null;
    private final Map<String, String> systemEnvironment;
    private final NamespaceRegistry namespaceRegistry;
    private final String homeDirectory;
    private final Environment baseEnvironment;
    private final Environment globalEnvironment;
    private final Environment baseNamespaceEnv;
    private final FileSystemManager fileSystemManager;
    private SecurityManager securityManager;
    private Map<Class, Object> singletons = Maps.newHashMap();
    private final ConnectionTable connectionTable = new ConnectionTable();
    private FileObject workingDirectory;
    private StringVector commandLineArguments = StringVector.valueOf("renjin");
    public RNG rng = new RNG(this);
    private SessionController sessionController = new SessionController();
    private VectorPipeliner vectorPipeliner;
    private ClassLoader classLoader;
    private List<DllInfo> loadedLibraries = new ArrayList<DllInfo>();
    boolean invisible;
    Context conditionStack = null;

    Session(FileSystemManager fileSystemManager, ClassLoader classLoader, PackageLoader packageLoader, ExecutorService executorService, Frame globalFrame) {
        this.fileSystemManager = fileSystemManager;
        this.classLoader = classLoader;
        this.homeDirectory = FileSystemUtils.homeDirectoryInCoreJar(fileSystemManager);
        this.workingDirectory = FileSystemUtils.workingDirectory(fileSystemManager);
        this.systemEnvironment = Maps.newHashMap(System.getenv());
        this.baseEnvironment = Environment.createBaseEnvironment(this);
        this.globalEnvironment = Environment.createGlobalEnvironment(this.baseEnvironment, globalFrame);
        this.baseNamespaceEnv = Environment.createBaseNamespaceEnvironment(this.globalEnvironment, this.baseEnvironment).build();
        this.topLevelContext = new Context(this);
        this.baseNamespaceEnv.setVariableUnsafe(Symbol.get(".BaseNamespaceEnv"), (SEXP)this.baseNamespaceEnv);
        this.namespaceRegistry = new NamespaceRegistry(packageLoader, this.baseNamespaceEnv);
        this.securityManager = new SecurityManager();
        this.vectorPipeliner = new VectorPipeliner(executorService);
        this.globalEnvironment.setVariable(this.topLevelContext, ".Random.seed", (SEXP)IntVector.valueOf(1));
    }

    public void setStdOut(PrintWriter writer) {
        this.connectionTable.getStdout().setStream(writer);
    }

    public void setStdIn(Reader reader) {
        this.connectionTable.getStdin().setReader(reader);
    }

    public void setStdErr(PrintWriter writer) {
        this.connectionTable.getStderr().setStream(writer);
    }

    public SessionController getSessionController() {
        return this.sessionController;
    }

    public <X> X getSingleton(Class<X> clazz) {
        if (clazz == NamespaceRegistry.class) {
            return (X)this.namespaceRegistry;
        }
        Object instance = this.singletons.get(clazz);
        if (instance == null) {
            try {
                instance = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Can instantiate singleton " + clazz.getName() + ": the class must have a public default constructor", e);
            }
            this.singletons.put(clazz, instance);
        }
        return (X)instance;
    }

    public Options getOptions() {
        return this.getSingleton(Options.class);
    }

    public void setSessionController(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public RNG getRNG() {
        return this.rng;
    }

    public Environment getGlobalEnvironment() {
        return this.globalEnvironment;
    }

    public ConnectionTable getConnectionTable() {
        return this.connectionTable;
    }

    public void setWorkingDirectory(FileObject dir2) {
        this.workingDirectory = dir2;
    }

    public void setWorkingDirectory(File dir2) throws FileSystemException {
        this.workingDirectory = this.fileSystemManager.resolveFile(dir2.getAbsolutePath());
    }

    public FileObject getWorkingDirectory() {
        return this.workingDirectory;
    }

    public VectorPipeliner getVectorEngine() {
        return this.vectorPipeliner;
    }

    public void setCommandLineArguments(String executableName, String ... arguments) {
        this.commandLineArguments = new StringArrayVector((Collection<String>)Lists.asList(executableName, arguments));
    }

    public void setCommandLineArguments(String executableName, List<String> arguments) {
        ArrayList<String> commandLine = Lists.newArrayList();
        commandLine.add(executableName);
        commandLine.addAll(arguments);
        this.commandLineArguments = new StringArrayVector((Collection<String>)commandLine);
    }

    public StringVector getCommandLineArguments() {
        return this.commandLineArguments;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public PrintWriter getStdOut() {
        return this.connectionTable.getStdout().getStream();
    }

    public PrintWriter getEffectiveStdOut() {
        return this.connectionTable.getStdout().getOpenPrintWriter();
    }

    public PrintWriter getStdErr() {
        return this.connectionTable.getStderr().getStream();
    }

    public PrintWriter getEffectiveStdErr() {
        return this.connectionTable.getStderr().getOpenPrintWriter();
    }

    public Reader getStdIn() {
        return this.connectionTable.getStdin().getReader();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public Context getTopLevelContext() {
        return this.topLevelContext;
    }

    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public FileObject resolveFile(String uri) throws FileSystemException {
        return this.fileSystemManager.resolveFile(this.workingDirectory, uri);
    }

    public Environment getBaseEnvironment() {
        return this.baseEnvironment;
    }

    public Environment getBaseNamespaceEnv() {
        return this.baseNamespaceEnv;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public Map<String, String> getSystemEnvironment() {
        return this.systemEnvironment;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public S4Cache getS4Cache() {
        return this.s4Cache;
    }

    public void registerFinalizer(SEXP sexp2, FinalizationHandler handler, boolean onExit) {
        if (this.finalizers == null) {
            this.finalizers = new FinalizerRegistry();
        }
        this.finalizers.register(sexp2, handler, onExit);
    }

    public void runFinalizers() {
        if (this.finalizers != null) {
            this.finalizers.finalizeDisposedEnvironments(this.topLevelContext);
        }
    }

    public void close() {
        this.topLevelContext.exit();
        if (this.finalizers != null) {
            this.finalizers.finalizeOnExit(this.topLevelContext);
        }
    }

    public MethodHandle getRngMethod() {
        return this.rng.getMethodHandle();
    }

    public void loadLibrary(DllInfo library2) {
        this.loadedLibraries.add(library2);
    }

    public Iterable<DllInfo> getLoadedLibraries() {
        return this.loadedLibraries;
    }

    public void printWarnings() {
        SEXP warnings = this.baseEnvironment.getVariable(this.topLevelContext, Warning.LAST_WARNING);
        if (warnings != Symbol.UNBOUND_VALUE) {
            this.topLevelContext.evaluate(FunctionCall.newCall(Symbol.get("print.warnings"), warnings), this.topLevelContext.getBaseEnvironment());
        }
    }

    public void clearWarnings() {
        this.baseEnvironment.remove(Warning.LAST_WARNING);
    }
}

