/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.util.Arrays;
import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.eval.MatchedArgumentPositions;
import org.renjin.eval.MatchedArguments;
import org.renjin.sexp.Closure;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class ArgumentMatcher {
    private final String[] formalNames;
    private final SEXP[] defaultValues;
    private int formalEllipses;

    public ArgumentMatcher(Closure closure) {
        this(closure.getFormals());
    }

    public ArgumentMatcher(PairList formals2) {
        int formalCount = formals2.length();
        this.formalNames = new String[formalCount];
        this.formalEllipses = -1;
        this.defaultValues = new SEXP[formalCount];
        int i = 0;
        for (PairList.Node node : formals2.nodes()) {
            SEXP tag = node.getRawTag();
            if (tag instanceof Symbol) {
                Symbol formalName = (Symbol)tag;
                if (formalName == Symbols.ELLIPSES) {
                    this.formalEllipses = i;
                }
                this.formalNames[i] = formalName.getPrintName();
            }
            this.defaultValues[i] = node.getValue();
            ++i;
        }
    }

    public ArgumentMatcher(String ... formalNames) {
        this.formalNames = Arrays.copyOf(formalNames, formalNames.length);
        this.defaultValues = new SEXP[formalNames.length];
        Arrays.fill(this.defaultValues, Symbol.MISSING_ARG);
        this.formalEllipses = -1;
        for (int i = 0; i < formalNames.length; ++i) {
            if (!formalNames[i].equals("...")) continue;
            this.formalEllipses = i;
        }
    }

    public int getNamedFormalCount() {
        if (this.formalEllipses == -1) {
            return this.formalNames.length;
        }
        return this.formalNames.length - 1;
    }

    public MatchedArgumentPositions match(String[] actualNames) {
        int[] formalToActual = new int[this.formalNames.length];
        Arrays.fill(formalToActual, -1);
        boolean[] matchedFormals = new boolean[this.formalNames.length];
        boolean[] matchedActuals = new boolean[actualNames.length];
        for (int formalIndex = 0; formalIndex < this.formalNames.length; ++formalIndex) {
            int exactMatchIndex;
            String formalName = this.formalNames[formalIndex];
            if (formalIndex == this.formalEllipses || (exactMatchIndex = ArgumentMatcher.findExactMatch(formalName, actualNames)) == -1) continue;
            formalToActual[formalIndex] = exactMatchIndex;
            matchedActuals[exactMatchIndex] = true;
            matchedFormals[formalIndex] = true;
        }
        for (int actualIndex = 0; actualIndex < actualNames.length; ++actualIndex) {
            int partialMatch;
            String actualName;
            if (matchedActuals[actualIndex] || (actualName = actualNames[actualIndex]) == null || actualName.equals("...") || (partialMatch = ArgumentMatcher.findPartialMatch(actualName, this.formalNames, matchedFormals)) == -1) continue;
            formalToActual[partialMatch] = actualIndex;
            matchedActuals[actualIndex] = true;
            matchedFormals[partialMatch] = true;
        }
        int nextActual = 0;
        for (int formalIndex = 0; formalIndex < this.formalNames.length && formalIndex != this.formalEllipses; ++formalIndex) {
            if (matchedFormals[formalIndex]) continue;
            if ((nextActual = ArgumentMatcher.findNextUnnamed(actualNames, nextActual)) == -1) break;
            formalToActual[formalIndex] = nextActual;
            matchedActuals[nextActual] = true;
            ++nextActual;
        }
        if (this.formalEllipses == -1 && this.hasUnmatched(matchedActuals)) {
            throw new EvalException("Unused arguments", new Object[0]);
        }
        return new MatchedArgumentPositions(this.formalNames, formalToActual, matchedActuals, this.formalEllipses);
    }

    public MatchedArguments match(PairList actuals) {
        int numActuals = actuals.length();
        SEXP[] actualTags = new SEXP[numActuals];
        String[] actualNames = new String[numActuals];
        SEXP[] actualValues = new SEXP[numActuals];
        int i = 0;
        for (PairList.Node node : actuals.nodes()) {
            actualTags[i] = node.getRawTag();
            if (node.hasName()) {
                actualNames[i] = node.getName();
            }
            actualValues[i] = node.getValue();
            ++i;
        }
        return new MatchedArguments(this.match(actualNames), actualTags, actualValues);
    }

    private boolean hasUnmatched(boolean[] matchedActuals) {
        for (int i = 0; i < matchedActuals.length; ++i) {
            if (matchedActuals[i]) continue;
            return true;
        }
        return false;
    }

    private static int findNextUnnamed(String[] actualNames, int start) {
        for (int i = start; i < actualNames.length; ++i) {
            if (actualNames[i] != null) continue;
            return i;
        }
        return -1;
    }

    private static int findExactMatch(String formalName, String[] argumentNames) {
        int match2 = -1;
        for (int i = 0; i < argumentNames.length; ++i) {
            if (argumentNames[i] == null || !argumentNames[i].equals(formalName)) continue;
            if (match2 != -1) {
                throw new EvalException(String.format("Multiple named values provided for argument '%s'", formalName), new Object[0]);
            }
            match2 = i;
        }
        return match2;
    }

    private static int findPartialMatch(String actualName, String[] formalNames, boolean[] matchedFormals) {
        int match2 = -1;
        for (int i = 0; i < formalNames.length; ++i) {
            if (matchedFormals[i]) continue;
            String formalName = formalNames[i];
            if (formalName.equals("...")) break;
            if (!formalName.startsWith(actualName)) continue;
            if (match2 != -1) {
                throw new EvalException(String.format("Provided argument '%s' matches multiple named formal arguments", actualName), new Object[0]);
            }
            match2 = i;
        }
        return match2;
    }

    public SEXP getDefaultValue(int formalIndex) {
        return this.defaultValues[formalIndex];
    }

    public List<String> getFormalNames() {
        return Arrays.asList(this.formalNames);
    }
}

