/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Map;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.SpecializedCallExpression;
import org.renjin.primitives.sequence.DoubleSequence;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.AtomicVector;

public class SequenceExpression
extends SpecializedCallExpression {
    private ValueBounds valueBounds;

    public SequenceExpression(Expression from, Expression to) {
        super(from, to);
    }

    @Override
    public boolean isFunctionDefinitelyPure() {
        return true;
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        ValueBounds fromType = this.childAt(0).updateTypeBounds(typeMap);
        ValueBounds toType = this.childAt(1).updateTypeBounds(typeMap);
        this.valueBounds = ValueBounds.builder().setTypeSet(fromType.getTypeSet() | toType.getTypeSet()).setEmptyAttributes().build();
        return this.valueBounds;
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.valueBounds;
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        this.childAt(0).load(emitContext, mv);
        emitContext.convert(mv, this.childAt(0).getType(), Type.DOUBLE_TYPE);
        this.childAt(1).load(emitContext, mv);
        emitContext.convert(mv, this.childAt(1).getType(), Type.DOUBLE_TYPE);
        mv.visitMethodInsn(184, Type.getInternalName(DoubleSequence.class), "fromTo", Type.getMethodDescriptor(Type.getType(AtomicVector.class), Type.DOUBLE_TYPE, Type.DOUBLE_TYPE), false);
        return 0;
    }

    @Override
    public Type getType() {
        return this.valueBounds.storageType();
    }

    public String toString() {
        return this.childAt(0) + ":" + this.childAt(1);
    }
}

