/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.codegen;

import org.renjin.compiler.ir.TypeSet;
import org.renjin.repackaged.asm.Type;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.LogicalArrayVector;

public enum VectorGen {
    LOGICAL{

        @Override
        public Type getElementType() {
            return Type.INT_TYPE;
        }

        @Override
        public Type getVectorArrayType() {
            return Type.getType(LogicalArrayVector.class);
        }
    }
    ,
    INTEGER{

        @Override
        public Type getElementType() {
            return Type.INT_TYPE;
        }

        @Override
        public Type getVectorArrayType() {
            return Type.getType(IntArrayVector.class);
        }
    }
    ,
    DOUBLE{

        @Override
        public Type getElementType() {
            return Type.DOUBLE_TYPE;
        }

        @Override
        public Type getVectorArrayType() {
            return Type.getType(DoubleArrayVector.class);
        }
    };


    public abstract Type getElementType();

    public abstract Type getVectorArrayType();

    public static VectorGen forType(int typeSet) {
        switch (typeSet) {
            case 8: {
                return LOGICAL;
            }
            case 16: {
                return INTEGER;
            }
            case 32: {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException("typeSet: " + TypeSet.toString(typeSet));
    }

    public Type getArrayType() {
        return Type.getType("[" + this.getElementType().getDescriptor());
    }
}

