/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.BuiltinSpecializer;
import org.renjin.compiler.builtins.ConstantCall;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.Specializer;
import org.renjin.compiler.builtins.UnspecializedCall;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.VectorGen;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.primitives.combine.Combine;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;

public class CombineSpecializer
implements Specializer,
BuiltinSpecializer {
    @Override
    public String getName() {
        return "c";
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public Specialization trySpecialize(RuntimeState runtimeState, List<ArgumentBounds> arguments) {
        SEXP constantResult = this.tryCombine(arguments);
        if (constantResult != null) {
            return new ConstantCall(constantResult);
        }
        if (this.allArgumentsArePrimitives(arguments)) {
            return new CombinePrimitives(arguments);
        }
        return UnspecializedCall.PURE;
    }

    private SEXP tryCombine(List<ArgumentBounds> arguments) {
        ListVector.NamedBuilder constants = ListVector.newNamedBuilder();
        for (ArgumentBounds argument : arguments) {
            if (argument.getBounds().isConstant()) {
                constants.add(argument.getName(), argument.getBounds().getConstantValue());
                continue;
            }
            return null;
        }
        return Combine.c(constants.build(), false);
    }

    private boolean allArgumentsArePrimitives(List<ArgumentBounds> arguments) {
        for (ArgumentBounds argument : arguments) {
            if (argument.getName() != null) {
                return false;
            }
            if ((argument.getBounds().getTypeSet() & 0xFFFFFE03) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean allAreConstant(List<ValueBounds> argumentBounds) {
        for (ValueBounds argumentBound : argumentBounds) {
            if (argumentBound.isConstant()) continue;
            return false;
        }
        return true;
    }

    private static class CombinePrimitives
    implements Specialization {
        private final ValueBounds bounds;

        public CombinePrimitives(List<ArgumentBounds> argumentBounds) {
            int length2 = 0;
            int typeSet = 4;
            for (ArgumentBounds argumentBound : argumentBounds) {
                typeSet = Math.max(typeSet, argumentBound.getBounds().getTypeSet());
                ++length2;
            }
            this.bounds = ValueBounds.builder().setLength(length2).setTypeSet(typeSet).setEmptyAttributes().build();
        }

        @Override
        public Type getType() {
            return this.bounds.storageType();
        }

        @Override
        public ValueBounds getResultBounds() {
            return this.bounds;
        }

        @Override
        public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
            VectorGen vectorType = VectorGen.forType(this.bounds.getTypeSet());
            int length2 = this.bounds.getLength();
            mv.iconst(length2);
            mv.newarray(vectorType.getElementType());
            mv.dup();
            for (int i = 0; i < length2; ++i) {
                mv.iconst(i);
                Expression expression2 = arguments.get(0).getExpression();
                expression2.load(emitContext, mv);
                emitContext.convert(mv, expression2.getType(), vectorType.getElementType());
                mv.astore(vectorType.getElementType());
            }
            mv.invokestatic(vectorType.getVectorArrayType().getInternalName(), "unsafe", Type.getMethodDescriptor(vectorType.getVectorArrayType(), vectorType.getArrayType()), false);
        }

        @Override
        public boolean isPure() {
            return true;
        }
    }
}

