/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.renjin.compiler.builtins.AnnotationBasedSpecializer;
import org.renjin.compiler.builtins.CombineSpecializer;
import org.renjin.compiler.builtins.DimSpecializer;
import org.renjin.compiler.builtins.GenericBuiltinGuard;
import org.renjin.compiler.builtins.InvisibleSpecializer;
import org.renjin.compiler.builtins.IsArraySpecializer;
import org.renjin.compiler.builtins.LengthSpecializer;
import org.renjin.compiler.builtins.RepSpecializer;
import org.renjin.compiler.builtins.ReplaceSpecializer;
import org.renjin.compiler.builtins.SingleSubsetSpecializer;
import org.renjin.compiler.builtins.Specializer;
import org.renjin.compiler.builtins.SubsetSpecializer;
import org.renjin.compiler.ir.exception.InternalCompilerException;
import org.renjin.primitives.Primitives;
import org.renjin.repackaged.guava.cache.CacheBuilder;
import org.renjin.repackaged.guava.cache.CacheLoader;
import org.renjin.repackaged.guava.cache.LoadingCache;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Symbol;

public class BuiltinSpecializers {
    public static final BuiltinSpecializers INSTANCE = new BuiltinSpecializers();
    private final Map<String, Specializer> specializers = Maps.newHashMap();
    private final LoadingCache<String, Specializer> cache;

    public BuiltinSpecializers() {
        this.specializers.put("length", new GenericBuiltinGuard(new LengthSpecializer()));
        this.specializers.put("[<-", new GenericBuiltinGuard(new ReplaceSpecializer()));
        this.specializers.put("[", new GenericBuiltinGuard(new SubsetSpecializer()));
        this.specializers.put("[[", new GenericBuiltinGuard(new SingleSubsetSpecializer()));
        this.specializers.put("c", new GenericBuiltinGuard(new CombineSpecializer()));
        this.specializers.put("is.array", new GenericBuiltinGuard(new IsArraySpecializer()));
        this.specializers.put("dim", new GenericBuiltinGuard(new DimSpecializer()));
        this.specializers.put("rep", new RepSpecializer());
        this.specializers.put("invisible", new InvisibleSpecializer());
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<String, Specializer>(){

            @Override
            public Specializer load(String primitive2) throws Exception {
                Symbol primitiveName = Symbol.get(primitive2);
                Primitives.Entry entry = Primitives.getBuiltinEntry(primitiveName);
                if (entry == null) {
                    entry = Primitives.getInternalEntry(primitiveName);
                }
                if (entry == null) {
                    throw new IllegalStateException("No builtin entry for " + primitiveName);
                }
                AnnotationBasedSpecializer specializer = new AnnotationBasedSpecializer(entry);
                if (specializer.isGeneric()) {
                    return new GenericBuiltinGuard(specializer);
                }
                return specializer;
            }
        });
    }

    public Specializer get(String primitiveName) {
        if (this.specializers.containsKey(primitiveName)) {
            return this.specializers.get(primitiveName);
        }
        try {
            return this.cache.get(primitiveName);
        }
        catch (ExecutionException e) {
            throw new InternalCompilerException(e);
        }
    }
}

