/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;

public class Expander {
    public void expand(File archive, File targetDirectory) throws IOException, ArchiveException {
        String format2 = null;
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            new ArchiveStreamFactory();
            format2 = ArchiveStreamFactory.detect(i);
        }
        this.expand(format2, archive, targetDirectory);
    }

    public void expand(String format2, File archive, File targetDirectory) throws IOException, ArchiveException {
        if (this.prefersSeekableByteChannel(format2)) {
            try (FileChannel c2 = FileChannel.open(archive.toPath(), StandardOpenOption.READ);){
                this.expand(format2, c2, targetDirectory);
            }
            return;
        }
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            this.expand(format2, i, targetDirectory);
        }
    }

    public void expand(InputStream archive, File targetDirectory) throws IOException, ArchiveException {
        this.expand(new ArchiveStreamFactory().createArchiveInputStream(archive), targetDirectory);
    }

    public void expand(String format2, InputStream archive, File targetDirectory) throws IOException, ArchiveException {
        this.expand(new ArchiveStreamFactory().createArchiveInputStream(format2, archive), targetDirectory);
    }

    public void expand(String format2, SeekableByteChannel archive, File targetDirectory) throws IOException, ArchiveException {
        if (!this.prefersSeekableByteChannel(format2)) {
            this.expand(format2, Channels.newInputStream(archive), targetDirectory);
        } else if ("zip".equalsIgnoreCase(format2)) {
            this.expand(new ZipFile(archive), targetDirectory);
        } else if ("7z".equalsIgnoreCase(format2)) {
            this.expand(new SevenZFile(archive), targetDirectory);
        } else {
            throw new ArchiveException("don't know how to handle format " + format2);
        }
    }

    public void expand(final ArchiveInputStream archive, File targetDirectory) throws IOException, ArchiveException {
        this.expand(new ArchiveEntrySupplier(){

            @Override
            public ArchiveEntry getNextReadableEntry() throws IOException {
                ArchiveEntry next = archive.getNextEntry();
                while (next != null && !archive.canReadEntryData(next)) {
                    next = archive.getNextEntry();
                }
                return next;
            }
        }, new EntryWriter(){

            @Override
            public void writeEntryDataTo(ArchiveEntry entry, OutputStream out) throws IOException {
                IOUtils.copy(archive, out);
            }
        }, targetDirectory);
    }

    public void expand(final ZipFile archive, File targetDirectory) throws IOException, ArchiveException {
        final Enumeration<ZipArchiveEntry> entries = archive.getEntries();
        this.expand(new ArchiveEntrySupplier(){

            @Override
            public ArchiveEntry getNextReadableEntry() throws IOException {
                ZipArchiveEntry next;
                ZipArchiveEntry zipArchiveEntry = next = entries.hasMoreElements() ? (ZipArchiveEntry)entries.nextElement() : null;
                while (next != null && !archive.canReadEntryData(next)) {
                    next = entries.hasMoreElements() ? (ZipArchiveEntry)entries.nextElement() : null;
                }
                return next;
            }
        }, new EntryWriter(){

            @Override
            public void writeEntryDataTo(ArchiveEntry entry, OutputStream out) throws IOException {
                try (InputStream in = archive.getInputStream((ZipArchiveEntry)entry);){
                    IOUtils.copy(in, out);
                }
            }
        }, targetDirectory);
    }

    public void expand(final SevenZFile archive, File targetDirectory) throws IOException, ArchiveException {
        this.expand(new ArchiveEntrySupplier(){

            @Override
            public ArchiveEntry getNextReadableEntry() throws IOException {
                return archive.getNextEntry();
            }
        }, new EntryWriter(){

            @Override
            public void writeEntryDataTo(ArchiveEntry entry, OutputStream out) throws IOException {
                byte[] buffer = new byte[8024];
                int n = 0;
                long count = 0L;
                while (-1 != (n = archive.read(buffer))) {
                    out.write(buffer, 0, n);
                    count += (long)n;
                }
            }
        }, targetDirectory);
    }

    private boolean prefersSeekableByteChannel(String format2) {
        return "zip".equalsIgnoreCase(format2) || "7z".equalsIgnoreCase(format2);
    }

    private void expand(ArchiveEntrySupplier supplier, EntryWriter writer, File targetDirectory) throws IOException {
        String targetDirPath = targetDirectory.getCanonicalPath();
        if (!targetDirPath.endsWith(File.separator)) {
            targetDirPath = targetDirPath + File.separatorChar;
        }
        ArchiveEntry nextEntry = supplier.getNextReadableEntry();
        while (nextEntry != null) {
            File f = new File(targetDirectory, nextEntry.getName());
            if (!f.getCanonicalPath().startsWith(targetDirPath)) {
                throw new IOException("expanding " + nextEntry.getName() + " would create file outside of " + targetDirectory);
            }
            if (nextEntry.isDirectory()) {
                if (!f.isDirectory() && !f.mkdirs()) {
                    throw new IOException("failed to create directory " + f);
                }
            } else {
                File parent2 = f.getParentFile();
                if (!parent2.isDirectory() && !parent2.mkdirs()) {
                    throw new IOException("failed to create directory " + parent2);
                }
                try (OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
                    writer.writeEntryDataTo(nextEntry, o);
                }
            }
            nextEntry = supplier.getNextReadableEntry();
        }
    }

    private static interface EntryWriter {
        public void writeEntryDataTo(ArchiveEntry var1, OutputStream var2) throws IOException;
    }

    private static interface ArchiveEntrySupplier {
        public ArchiveEntry getNextReadableEntry() throws IOException;
    }
}

