/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JTypeVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JNarrowedClass
extends JClass {
    final JClass basis;
    private final List<JClass> args;

    JNarrowedClass(JClass basis, JClass arg) {
        this(basis, Collections.singletonList(arg));
    }

    JNarrowedClass(JClass basis, List<JClass> args2) {
        super(basis.owner());
        this.basis = basis;
        assert (!(basis instanceof JNarrowedClass));
        this.args = args2;
    }

    @Override
    public JClass narrow(JClass clazz) {
        ArrayList<JClass> newArgs = new ArrayList<JClass>(this.args);
        newArgs.add(clazz);
        return new JNarrowedClass(this.basis, newArgs);
    }

    @Override
    public JClass narrow(JClass ... clazz) {
        ArrayList<JClass> newArgs = new ArrayList<JClass>(this.args);
        newArgs.addAll(Arrays.asList(clazz));
        return new JNarrowedClass(this.basis, newArgs);
    }

    @Override
    public String name() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.basis.name());
        buf.append('<');
        boolean first = true;
        for (JClass c2 : this.args) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(c2.name());
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public String fullName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.basis.fullName());
        buf.append('<');
        boolean first = true;
        for (JClass c2 : this.args) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(c2.fullName());
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public String binaryName() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.basis.binaryName());
        buf.append('<');
        boolean first = true;
        for (JClass c2 : this.args) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(c2.binaryName());
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public void generate(JFormatter f) {
        f.t(this.basis).p('<').g(this.args).p('\uffff');
    }

    @Override
    void printLink(JFormatter f) {
        this.basis.printLink(f);
        f.p("{@code <}");
        boolean first = true;
        for (JClass c2 : this.args) {
            if (first) {
                first = false;
            } else {
                f.p(',');
            }
            c2.printLink(f);
        }
        f.p("{@code >}");
    }

    @Override
    public JPackage _package() {
        return this.basis._package();
    }

    @Override
    public JClass _extends() {
        JClass base = this.basis._extends();
        if (base == null) {
            return base;
        }
        return base.substituteParams(this.basis.typeParams(), this.args);
    }

    @Override
    public Iterator<JClass> _implements() {
        return new Iterator<JClass>(){
            private final Iterator<JClass> core;
            {
                this.core = JNarrowedClass.this.basis._implements();
            }

            @Override
            public void remove() {
                this.core.remove();
            }

            @Override
            public JClass next() {
                return this.core.next().substituteParams(JNarrowedClass.this.basis.typeParams(), JNarrowedClass.this.args);
            }

            @Override
            public boolean hasNext() {
                return this.core.hasNext();
            }
        };
    }

    @Override
    public JClass erasure() {
        return this.basis;
    }

    @Override
    public boolean isInterface() {
        return this.basis.isInterface();
    }

    @Override
    public boolean isAbstract() {
        return this.basis.isAbstract();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JNarrowedClass)) {
            return false;
        }
        return this.fullName().equals(((JClass)obj).fullName());
    }

    public int hashCode() {
        return this.fullName().hashCode();
    }

    @Override
    protected JClass substituteParams(JTypeVar[] variables, List<JClass> bindings) {
        JClass b = this.basis.substituteParams(variables, bindings);
        boolean different = b != this.basis;
        ArrayList<JClass> clazz = new ArrayList<JClass>(this.args.size());
        for (int i = 0; i < clazz.size(); ++i) {
            JClass c2 = this.args.get(i).substituteParams(variables, bindings);
            clazz.set(i, c2);
            different |= c2 != this.args.get(i);
        }
        if (different) {
            return new JNarrowedClass(b, clazz);
        }
        return this;
    }

    @Override
    public List<JClass> getTypeParameters() {
        return this.args;
    }
}

