/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.PenEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class JRGraphicElementFactory
extends JRBaseFactory {
    private static final Log log = LogFactory.getLog(JRGraphicElementFactory.class);

    public Object createObject(Attributes atts) {
        FillEnum fill;
        PenEnum pen;
        JRDesignGraphicElement graphicElement = (JRDesignGraphicElement)this.digester.peek();
        StretchTypeEnum stretchType = StretchTypeEnum.getByName(atts.getValue("stretchType"));
        if (stretchType != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'stretchType' attribute in <graphicElement> tag is deprecated. Use the same attribut in <reportElement> tag instead.");
            }
            graphicElement.setStretchType(stretchType);
        }
        if ((pen = PenEnum.getByName(atts.getValue("pen"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'pen' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(pen, graphicElement.getLinePen());
        }
        if ((fill = FillEnum.getByName(atts.getValue("fill"))) != null) {
            graphicElement.setFill(fill);
        }
        return graphicElement;
    }
}

