/*
 * Decompiled with CFR 0.152.
 */
package org.gsweb.components.util;

import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ComponentResourceUtils {
    private static Map<String, Object> resource = new HashMap<String, Object>();

    public static synchronized Object get(String key) {
        return resource.get(key);
    }

    public static synchronized void put(String key, Object value) {
        if (resource.get(key) == null) {
            resource.put(key, value);
        }
    }

    public static String getResourceSrc(Class<?> c, String metaInfJSFile) {
        String key = c.getName();
        String out = (String)ComponentResourceUtils.get(key);
        if (out == null) {
            try {
                out = IOUtils.toString(c.getClassLoader().getResource(metaInfJSFile).openStream(), "utf-8");
                ComponentResourceUtils.put(key, out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    public static String getResourceSrc(Class<?> c, String type, String metaInfFile) {
        String key = String.valueOf(c.getName()) + "." + type;
        String out = (String)ComponentResourceUtils.get(key);
        if (out == null) {
            try {
                out = IOUtils.toString(c.getClassLoader().getResource(metaInfFile).openStream(), "utf-8");
                ComponentResourceUtils.put(key, out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    public static String generatorResource(Class<?> c, String type, String metaInfFile, Map<String, Object> params) throws Exception {
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate("resourceTemplate", ComponentResourceUtils.getResourceSrc(c, type, metaInfFile));
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);
        cfg.setTemplateLoader(templateLoader);
        Template template = cfg.getTemplate("resourceTemplate", "utf-8");
        StringWriter out = new StringWriter();
        template.process(params, out);
        return ((Object)out).toString();
    }

    public static String getScriptFunctionNameForXhrMain(String functionName) {
        if (StringUtils.isBlank(functionName)) {
            return "";
        }
        if ((functionName = functionName.trim()).indexOf(";") > -1) {
            functionName = StringUtils.replaceOnce(functionName, ";", "");
        }
        if (functionName.indexOf(")") == -1) {
            functionName = String.valueOf(functionName) + "()";
        }
        return functionName;
    }

    public static String getScriptFunctionNameForGridParams(String functionName) {
        if (StringUtils.isBlank(functionName)) {
            return "";
        }
        if ((functionName = functionName.trim()).indexOf(";") > -1) {
            functionName = StringUtils.replaceOnce(functionName, ";", "");
        }
        return functionName;
    }

    public static String getScriptFunctionNameForInCall(String functionName) {
        if (StringUtils.isBlank(functionName)) {
            return "";
        }
        if ((functionName = functionName.trim()).indexOf(")") == -1) {
            functionName = String.valueOf(functionName) + "()";
        }
        if (functionName.indexOf(";") == -1) {
            functionName = String.valueOf(functionName) + ";";
        }
        return functionName;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parameterType", "postData");
        params.put("id", "test");
        params.put("onClick", "myFunction_AA");
        params.put("xhrParameter", " ");
        params.put("xhrUrl", "mydata.do");
        params.put("handleAs", "json");
        params.put("timeout", "600000");
        params.put("sync", "true");
        params.put("preventCache", "true");
        params.put("loadFn", "aa();");
        params.put("errorFn", "bb();");
        System.out.println(ComponentResourceUtils.generatorResource(ComponentResourceUtils.class, "script", "META-INF/resource/button/ui.button.js", params));
    }
}

