/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.sys;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class HibernateExtendedJpaDialect
extends HibernateJpaDialect {
    private static final long serialVersionUID = -5505680328318555204L;
    private Logger logger = Logger.getLogger(HibernateExtendedJpaDialect.class);

    @Override
    public Object beginTransaction(EntityManager entityManager, final TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        Session session = (Session)entityManager.getDelegate();
        if (definition.getTimeout() != -1) {
            this.getSession(entityManager).getTransaction().setTimeout(definition.getTimeout());
        }
        entityManager.getTransaction().begin();
        this.logger.debug("Transaction started");
        session.doWork(new Work(){

            @Override
            public void execute(Connection connection) throws SQLException {
                HibernateExtendedJpaDialect.this.logger.debug("The connection instance is " + connection.toString());
                HibernateExtendedJpaDialect.this.logger.debug("The isolation level of the connection is " + connection.getTransactionIsolation() + " and the isolation level set on the transaction is " + definition.getIsolationLevel());
                DataSourceUtils.prepareConnectionForTransaction(connection, definition);
            }
        });
        return this.prepareTransaction(entityManager, definition.isReadOnly(), definition.getName());
    }
}

