/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.service.logic;

import com.netsteadfast.greenstep.util.SimpleUtils;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public abstract class BaseLogicService {
    public String getAccountId() {
        Subject subject = SecurityUtils.getSubject();
        return this.defaultString((String)subject.getPrincipal());
    }

    public String generateOid() {
        return SimpleUtils.getUUIDStr();
    }

    public String defaultString(String source) {
        return SimpleUtils.getStr(source, "");
    }

    public boolean isBlank(String source) {
        return StringUtils.isBlank(source);
    }

    protected boolean isNoSelectId(String value) {
        return StringUtils.isBlank(value) || "all".equals(value);
    }

    public <T> T setStringValueMaxLength(T obj, String fieldName, int maxLength) {
        if (obj == null) {
            return obj;
        }
        try {
            Object value = Ognl.getValue(fieldName, obj);
            if (!(value instanceof String)) {
                return obj;
            }
            if (this.isBlank((String)value) || ((String)value).length() <= maxLength) {
                return obj;
            }
            value = ((String)value).substring(0, maxLength);
            Ognl.setValue(fieldName, obj, value);
        }
        catch (OgnlException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public <T> T replaceSplit2Blank(T obj, String fieldName, String split) {
        if (obj == null) {
            return obj;
        }
        try {
            Object value = Ognl.getValue(fieldName, obj);
            if (!(value instanceof String)) {
                return obj;
            }
            if (this.isBlank((String)value)) {
                return obj;
            }
            value = ((String)value).replaceAll(split, "");
            Ognl.setValue(fieldName, obj, value);
        }
        catch (OgnlException e) {
            e.printStackTrace();
        }
        return obj;
    }
}

