/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.service;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.dao.IBaseDAO;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.BaseEntity;
import com.netsteadfast.greenstep.base.model.BaseEntityUtil;
import com.netsteadfast.greenstep.base.model.CustomeOperational;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.DynamicHqlQueryParamHandler;
import com.netsteadfast.greenstep.base.model.SearchValue;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.model.dynamichql.DynamicHql;
import com.netsteadfast.greenstep.base.service.ISimpleService;
import com.netsteadfast.greenstep.util.SimpleUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class SimpleService<E extends Serializable, PK extends Serializable>
implements ISimpleService<E, PK> {
    protected PlatformTransactionManager platformTransactionManager;
    protected TransactionTemplate transactionTemplate;

    public PlatformTransactionManager getPlatformTransactionManager() {
        if (this.platformTransactionManager == null) {
            this.platformTransactionManager = (PlatformTransactionManager)AppContext.getBean("transactionManager");
        }
        return this.platformTransactionManager;
    }

    @Autowired
    @Resource(name="transactionManager")
    @Required
    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }

    public TransactionTemplate getTransactionTemplate() {
        if (this.transactionTemplate == null) {
            this.transactionTemplate = (TransactionTemplate)AppContext.getBean("transactionTemplate");
        }
        return this.transactionTemplate;
    }

    @Autowired
    @Resource(name="transactionTemplate")
    @Required
    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public boolean isSuperRole() {
        Subject subject = SecurityUtils.getSubject();
        return subject.hasRole("admin") || subject.hasRole("*");
    }

    @Override
    public String getAccountId() {
        Subject subject = SecurityUtils.getSubject();
        return this.defaultString((String)subject.getPrincipal());
    }

    @Override
    public String generateOid() {
        return SimpleUtils.getUUIDStr();
    }

    @Override
    public String defaultString(String source) {
        return SimpleUtils.getStr(source, "");
    }

    @Override
    public Date generateDate() {
        return new Date();
    }

    @Override
    public void copyProperties(Object source, Object target) throws BeansException {
        BeanUtils.copyProperties(source, target);
    }

    public void populate(Object bean, Map<String, Object> properties) throws IllegalAccessException, InvocationTargetException {
        org.apache.commons.beanutils.BeanUtils.populate(bean, properties);
    }

    @Override
    public void fillToValueObject(Object destObject, Object origObject) throws ServiceException, IllegalAccessException, InvocationTargetException {
        if (destObject == null || origObject == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        org.apache.commons.beanutils.BeanUtils.copyProperties(destObject, origObject);
    }

    @Override
    public void fillToPersisentObject(Object destObject, Object origObject) throws ServiceException, IllegalAccessException, InvocationTargetException {
        if (destObject == null || origObject == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        org.apache.commons.beanutils.BeanUtils.copyProperties(destObject, origObject);
    }

    protected abstract IBaseDAO<E, String> getBaseDataAccessObject();

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<E> saveEntityIgnoreUK(E object) throws ServiceException, Exception {
        return this.saveOrMergeEntity("save", false, object);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<E> mergeEntityIgnoreUK(E object) throws ServiceException, Exception {
        return this.saveOrMergeEntity("merge", false, object);
    }

    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    private DefaultResult<E> saveOrMergeEntity(String type, boolean checkUK, E object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult result = new DefaultResult();
        if (checkUK) {
            int countByUK = 1;
            try {
                countByUK = this.getBaseDataAccessObject().countByUK(object);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (countByUK > 0) {
                throw new ServiceException(SysMessageUtil.get("MSG_DOS0002"));
            }
        }
        ((BaseEntity)object).setOid(this.generateOid());
        ((BaseEntity)object).setCuserid(this.getAccountId());
        ((BaseEntity)object).setCdate(this.generateDate());
        Object insertEntity = null;
        try {
            insertEntity = "save".equals(type) ? (Object)this.getBaseDataAccessObject().save(object) : (Object)this.getBaseDataAccessObject().merge(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (insertEntity != null && ((BaseEntity)insertEntity).getOid() != null) {
            result.setValue(insertEntity);
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0005")));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0006")));
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public DefaultResult<E> findEntityByOid(E object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult<E> result = new DefaultResult<E>();
        try {
            E entityObject = this.findByOid(object);
            if (entityObject != null && !StringUtils.isBlank((CharSequence)((BaseEntity)entityObject).getOid())) {
                result.setValue(entityObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result.getValue() == null) {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<E> saveEntity(E object) throws ServiceException, Exception {
        return this.saveOrMergeEntity("save", true, object);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<E> updateEntity(E object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult<E> result = new DefaultResult<E>();
        try {
            ((BaseEntity)object).setUuserid(this.getAccountId());
            ((BaseEntity)object).setUdate(this.generateDate());
            object = this.getBaseDataAccessObject().update(object);
            if (object != null && ((BaseEntity)object).getOid() != null) {
                result.setValue(object);
                result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result.getValue() == null) {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0004")));
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<E> mergeEntity(E object) throws ServiceException, Exception {
        return this.saveOrMergeEntity("merge", true, object);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deleteEntity(E object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        boolean status = false;
        if (this.countByOid(object) > 0) {
            this.delete(object);
            status = true;
        }
        result.setValue(status);
        if (status) {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0007")));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0008")));
        }
        return result;
    }

    @Override
    public void hibernateSessionClear() throws Exception {
        this.getBaseDataAccessObject().clear();
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public E save(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().save(entityObject);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public E update(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().update(entityObject);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public E merge(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().merge(entityObject);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public E delete(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().delete(entityObject);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public E saveRequiresNew(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().save(entityObject);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public E mergeRequiresNew(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().merge(entityObject);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public E findByOid(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        if (StringUtils.isBlank((CharSequence)((BaseEntity)entityObject).getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
        }
        return this.getBaseDataAccessObject().findByOid(entityObject);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public int countByOid(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        if (StringUtils.isBlank((CharSequence)((BaseEntity)entityObject).getOid())) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0001"));
        }
        return this.getBaseDataAccessObject().countByOid(entityObject);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public boolean deleteByPK(String pk) throws ServiceException, Exception {
        if (pk == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().deleteByPK(pk);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public E findByPK(String pk) throws ServiceException, Exception {
        if (pk == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().findByPK(pk);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public int countByPK(String pk) throws ServiceException, Exception {
        if (pk == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().countByPK(pk);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public boolean deleteByPK(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        Map<String, Object> pkMap = BaseEntityUtil.getPKParameter((BaseEntity)entityObject);
        if (pkMap == null || pkMap.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0002"));
        }
        return this.getBaseDataAccessObject().deleteByPK((String)((Object)pkMap));
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public E findByPK(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        Map<String, Object> pkMap = BaseEntityUtil.getPKParameter((BaseEntity)entityObject);
        if (pkMap == null || pkMap.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0002"));
        }
        return this.getBaseDataAccessObject().findByPK((String)((Object)pkMap));
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public int countByPK(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        Map<String, Object> pkMap = BaseEntityUtil.getPKParameter((BaseEntity)entityObject);
        if (pkMap == null || pkMap.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0002"));
        }
        return this.getBaseDataAccessObject().countByPK((String)((Object)pkMap));
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public boolean deleteByPKng(PK pk) throws ServiceException, Exception {
        if (pk == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().deleteByPK((String)pk);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public E findByPKng(PK pk) throws ServiceException, Exception {
        if (pk == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().findByPK((String)pk);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public int countByPKng(PK pk) throws ServiceException, Exception {
        if (pk == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        return this.getBaseDataAccessObject().countByPK((String)pk);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public long countByParams(Map<String, Object> params, Map<String, String> likeParams) throws ServiceException, Exception {
        return this.getBaseDataAccessObject().countByParams(params, likeParams);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public long countByParams(Map<String, Object> params) throws ServiceException, Exception {
        return this.countByParams(params, null);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public List<E> findListByParams(Map<String, Object> params, Map<String, String> likeParams) throws ServiceException, Exception {
        return this.getBaseDataAccessObject().findListByParams(params, likeParams, null);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public List<E> findListByParams(Map<String, Object> params, Map<String, String> likeParams, Map<String, String> orderParams) throws ServiceException, Exception {
        return this.getBaseDataAccessObject().findListByParams(params, likeParams, orderParams);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public List<E> findListByParams(Map<String, Object> params) throws ServiceException, Exception {
        return this.findListByParams(params, null);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public List<E> findListByParams2(Map<String, CustomeOperational> customOperParams) throws ServiceException, Exception {
        return this.getBaseDataAccessObject().findListByParams2(customOperParams);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public List<E> findListByParams2(Map<String, Object> params, Map<String, CustomeOperational> customOperParams) throws ServiceException, Exception {
        return this.getBaseDataAccessObject().findListByParams2(params, customOperParams);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public List<E> findListByParams2(Map<String, Object> params, Map<String, String> likeParams, Map<String, CustomeOperational> customOperParams) throws ServiceException, Exception {
        return this.getBaseDataAccessObject().findListByParams2(params, likeParams, customOperParams);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public List<E> findListByParams2(Map<String, Object> params, Map<String, String> likeParams, Map<String, CustomeOperational> customOperParams, Map<String, String> orderParams) throws ServiceException, Exception {
        return this.getBaseDataAccessObject().findListByParams2(params, likeParams, customOperParams, orderParams);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public DefaultResult<E> findEntityByUK(E object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult<E> result = new DefaultResult<E>();
        try {
            E entityByUK = this.getBaseDataAccessObject().findByUK(object);
            if (entityByUK != null && !StringUtils.isBlank((CharSequence)((BaseEntity)entityByUK).getOid())) {
                result.setValue(entityByUK);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result.getValue() == null) {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public E findByEntityUK(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        Map<String, Object> ukMap = BaseEntityUtil.getUKParameter((BaseEntity)entityObject);
        if (ukMap == null || ukMap.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0002"));
        }
        return this.getBaseDataAccessObject().findByEntityUK(ukMap);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public int countByEntityUK(E entityObject) throws ServiceException, Exception {
        if (entityObject == null || !(entityObject instanceof BaseEntity)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        Map<String, Object> ukMap = BaseEntityUtil.getUKParameter((BaseEntity)entityObject);
        if (ukMap == null || ukMap.size() < 1) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0002"));
        }
        return this.getBaseDataAccessObject().countByEntityUK(ukMap);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public DefaultResult<List<E>> ibatisSelectListByParams(Map<String, Object> params) throws ServiceException, Exception {
        if (params == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult<List<E>> result = new DefaultResult<List<E>>();
        List<E> searchList = this.getBaseDataAccessObject().ibatisSelectListByParams(params);
        if (searchList != null && searchList.size() > 0) {
            result.setValue(searchList);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public DefaultResult<E> ibatisSelectOneByValue(E valueObj) throws ServiceException, Exception {
        if (valueObj == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult<E> result = new DefaultResult<E>();
        E searchResult = this.getBaseDataAccessObject().ibatisSelectOneByValue(valueObj);
        if (searchResult != null) {
            result.setValue(searchResult);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }

    protected Map<String, String> providedSelectZeroDataMap(boolean pleaseSelectItem) {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        if (pleaseSelectItem) {
            dataMap.put("all", " - please select - ");
        }
        return dataMap;
    }

    protected boolean isNoSelectId(String value) {
        return StringUtils.isBlank(value) || "all".equals(value);
    }

    protected DynamicHqlQueryParamHandler getQueryParamHandler(SearchValue searchValue) {
        DynamicHqlQueryParamHandler queryParamHandler = new DynamicHqlQueryParamHandler();
        queryParamHandler.setSourceSearchParameterAndRoot(searchValue.getParameter());
        return queryParamHandler;
    }

    @Override
    public DynamicHql getDynamicHqlResource(String resource) throws Exception {
        return this.getBaseDataAccessObject().getDynamicHqlResource(resource);
    }

    @Override
    public String getDynamicHql(String queryName, Map<String, Object> paramMap) throws Exception {
        return this.getBaseDataAccessObject().getDynamicHql(queryName, paramMap);
    }

    @Override
    public String getDynamicHql(String resource, String queryName, Map<String, Object> paramMap) throws Exception {
        return this.getBaseDataAccessObject().getDynamicHql(resource, queryName, paramMap);
    }
}

