/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.service;

import com.netsteadfast.greenstep.base.SysMessageUtil;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.BaseEntity;
import com.netsteadfast.greenstep.base.model.BaseValueObj;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.base.model.ServiceMethodAuthority;
import com.netsteadfast.greenstep.base.model.ServiceMethodType;
import com.netsteadfast.greenstep.base.model.SystemMessage;
import com.netsteadfast.greenstep.base.service.IBaseService;
import com.netsteadfast.greenstep.base.service.SimpleService;
import com.netsteadfast.greenstep.util.GenericsUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.dozer.MappingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseService<T extends Serializable, E extends Serializable, PK extends Serializable>
extends SimpleService<E, PK>
implements IBaseService<T, E, PK> {
    protected Mapper mapper;

    public Mapper getMapper() {
        return this.mapper;
    }

    @Autowired
    @Resource(name="mapper")
    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void doMapper(Object sourceObject, Object targetObject, String mapperId) throws MappingException, ServiceException {
        if (mapperId == null || StringUtils.isBlank(mapperId)) {
            throw new ServiceException(SysMessageUtil.get("MSG_BSE0003"));
        }
        this.mapper.map(sourceObject, targetObject, mapperId);
    }

    public abstract String getMapperIdPo2Vo();

    public abstract String getMapperIdVo2Po();

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<T> saveIgnoreUK(T object) throws ServiceException, Exception {
        return this.saveOrMergeObject("save", false, object);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<T> mergeIgnoreUK(T object) throws ServiceException, Exception {
        return this.saveOrMergeObject("merge", false, object);
    }

    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    private DefaultResult<T> saveOrMergeObject(String type, boolean checkUK, T object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseValueObj)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult<Serializable> result = new DefaultResult<Serializable>();
        Class valueObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 0);
        Class entityObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 1);
        Serializable entityObject = (Serializable)entityObjectClass.newInstance();
        this.doMapper(object, entityObject, this.getMapperIdVo2Po());
        if (checkUK) {
            int countByUK = 1;
            try {
                countByUK = this.getBaseDataAccessObject().countByUK(entityObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (countByUK > 0) {
                throw new ServiceException(SysMessageUtil.get("MSG_DOS0002"));
            }
        }
        ((BaseEntity)((Object)entityObject)).setOid(this.generateOid());
        ((BaseEntity)((Object)entityObject)).setCuserid(this.getAccountId());
        ((BaseEntity)((Object)entityObject)).setCdate(this.generateDate());
        Serializable insertEntity = null;
        try {
            insertEntity = "save".equals(type) ? this.getBaseDataAccessObject().save(entityObject) : this.getBaseDataAccessObject().merge(entityObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (insertEntity != null && ((BaseEntity)((Object)insertEntity)).getOid() != null) {
            Serializable insertValueObj = (Serializable)valueObjectClass.newInstance();
            this.doMapper(insertEntity, insertValueObj, this.getMapperIdPo2Vo());
            result.setValue(insertValueObj);
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0005")));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0006")));
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public DefaultResult<T> findObjectByOid(T object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseValueObj)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        Class valueObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 0);
        Class entityObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 1);
        Serializable entityObject = (Serializable)entityObjectClass.newInstance();
        Serializable objectByOid = null;
        try {
            this.doMapper(object, entityObject, this.getMapperIdVo2Po());
            Serializable entityByOid = this.findByOid(entityObject);
            if (entityByOid != null) {
                objectByOid = (Serializable)valueObjectClass.newInstance();
                this.doMapper(entityByOid, objectByOid, this.getMapperIdPo2Vo());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DefaultResult<Serializable> result = new DefaultResult<Serializable>();
        if (objectByOid != null && !StringUtils.isBlank(((BaseValueObj)((Object)objectByOid)).getOid())) {
            result.setValue(objectByOid);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<T> saveObject(T object) throws ServiceException, Exception {
        return this.saveOrMergeObject("save", true, object);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<T> updateObject(T object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseValueObj)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult<Serializable> result = new DefaultResult<Serializable>();
        Class valueObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 0);
        Class entityObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 1);
        Serializable entityObject = (Serializable)entityObjectClass.newInstance();
        ((BaseEntity)((Object)entityObject)).setOid(((BaseValueObj)object).getOid());
        Serializable findEntity = this.findByOid(entityObject);
        if (findEntity == null) {
            throw new ServiceException(SysMessageUtil.get("MSG_DOS0009"));
        }
        this.doMapper(object, findEntity, this.getMapperIdVo2Po());
        Serializable updateEntity = null;
        try {
            ((BaseEntity)((Object)findEntity)).setUuserid(this.getAccountId());
            ((BaseEntity)((Object)findEntity)).setUdate(this.generateDate());
            updateEntity = this.getBaseDataAccessObject().update(findEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (updateEntity != null && ((BaseEntity)((Object)updateEntity)).getOid() != null) {
            Serializable updateValueObj = (Serializable)valueObjectClass.newInstance();
            this.doMapper(updateEntity, updateValueObj, this.getMapperIdPo2Vo());
            result.setValue(updateValueObj);
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0003")));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0004")));
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.INSERT, ServiceMethodType.UPDATE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<T> mergeObject(T object) throws ServiceException, Exception {
        return this.saveOrMergeObject("merge", true, object);
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.DELETE})
    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={RuntimeException.class, IOException.class, Exception.class})
    public DefaultResult<Boolean> deleteObject(T object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseValueObj)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        DefaultResult<Boolean> result = new DefaultResult<Boolean>();
        Class entityObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 1);
        Serializable entityObject = (Serializable)entityObjectClass.newInstance();
        ((BaseEntity)((Object)entityObject)).setOid(((BaseValueObj)object).getOid());
        boolean status = false;
        if (this.countByOid(entityObject) > 0) {
            this.delete(entityObject);
            status = true;
        }
        result.setValue(status);
        if (status) {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0007")));
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0008")));
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public List<T> findListVOByParams(Map<String, Object> params) throws ServiceException, Exception {
        ArrayList<Serializable> returnList = null;
        List searchList = this.findListByParams(params, null);
        if (searchList == null || searchList.size() < 1) {
            return returnList;
        }
        returnList = new ArrayList<Serializable>();
        for (Serializable entity : searchList) {
            Class objectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 0);
            Serializable obj = (Serializable)objectClass.newInstance();
            this.doMapper(entity, obj, this.getMapperIdPo2Vo());
            returnList.add(obj);
        }
        return returnList;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public DefaultResult<T> findByUK(T object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseValueObj)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        Class valueObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 0);
        Class entityObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 1);
        Serializable entityObject = (Serializable)entityObjectClass.newInstance();
        Serializable objectByUK = null;
        try {
            this.doMapper(object, entityObject, this.getMapperIdVo2Po());
            Serializable entityByUK = this.getBaseDataAccessObject().findByUK(entityObject);
            if (entityByUK != null) {
                objectByUK = (Serializable)valueObjectClass.newInstance();
                this.doMapper(entityByUK, objectByUK, this.getMapperIdPo2Vo());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DefaultResult<Serializable> result = new DefaultResult<Serializable>();
        if (objectByUK != null && !StringUtils.isBlank(((BaseValueObj)((Object)objectByUK)).getOid())) {
            result.setValue(objectByUK);
        } else {
            result.setSystemMessage(new SystemMessage(SysMessageUtil.get("MSG_DOS0009")));
        }
        return result;
    }

    @Override
    @ServiceMethodAuthority(type={ServiceMethodType.SELECT})
    @Transactional(isolation=Isolation.READ_COMMITTED, timeout=25, readOnly=true)
    public int countByUK(T object) throws ServiceException, Exception {
        if (object == null || !(object instanceof BaseValueObj)) {
            throw new ServiceException(SysMessageUtil.get("MSG_UOS0003"));
        }
        int count = 0;
        Class entityObjectClass = GenericsUtils.getSuperClassGenricType(this.getClass(), 1);
        Serializable entityObject = (Serializable)entityObjectClass.newInstance();
        try {
            this.doMapper(object, entityObject, this.getMapperIdVo2Po());
            count = this.getBaseDataAccessObject().countByUK(entityObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }
}

