/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.model;

import com.netsteadfast.greenstep.base.model.EntityUK;
import com.netsteadfast.greenstep.base.model.SqlGenerate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

public class SqlGenerateUtil
implements SqlGenerate {
    public static Map<String, Object> getInsert(Object entityObject) throws Exception {
        String tableName = SqlGenerateUtil.getTableName(entityObject);
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        Map<String, Object> fieldMap = SqlGenerateUtil.getField(entityObject);
        if ("".equals(tableName.trim()) || fieldMap == null || fieldMap.size() < 1) {
            throw new IllegalArgumentException("not entity bean.");
        }
        int field = 0;
        StringBuilder sql = new StringBuilder();
        Object[] params = new Object[fieldMap.size()];
        sql.append(" insert into ").append(tableName).append(" ( ");
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            params[field] = entry.getValue();
            sql.append(" ").append(entry.getKey());
            if (++field >= fieldMap.size()) continue;
            sql.append(", ");
        }
        sql.append(" ) ");
        sql.append(" values ( ");
        int ix = 1;
        while (ix <= params.length) {
            sql.append(" ").append("?");
            if (ix < fieldMap.size()) {
                sql.append(", ");
            }
            ++ix;
        }
        sql.append(" ) ");
        queryMap.put("sql", sql.toString());
        queryMap.put("params", params);
        return queryMap;
    }

    public static Map<String, Object> getCountByPK(Object entityObject) throws Exception {
        return SqlGenerateUtil.getByPK("count(*)", entityObject);
    }

    public static Map<String, Object> getFindByPK(Object entityObject, String ... fields) throws Exception {
        return SqlGenerateUtil.getByPK(SqlGenerateUtil.getSelectFields(fields), entityObject);
    }

    public static Map<String, Object> getCountByUK(Object entityObject) throws Exception {
        return SqlGenerateUtil.getByUK("count(*)", entityObject);
    }

    public static Map<String, Object> getFindByUK(Object entityObject, String ... fields) throws Exception {
        return SqlGenerateUtil.getByUK(SqlGenerateUtil.getSelectFields(fields), entityObject);
    }

    private static String getSelectFields(String ... fields) {
        if (fields == null || fields.length < 1) {
            return "*";
        }
        StringBuilder f = new StringBuilder();
        int ix = 0;
        while (ix < fields.length) {
            if (ix > 0) {
                f.append(", ");
            }
            f.append(fields[ix]);
            ++ix;
        }
        return f.toString();
    }

    public static Map<String, Object> getFindByParams(Object entityObject) throws Exception {
        String tableName = SqlGenerateUtil.getTableName(entityObject);
        Map<String, Object> fieldMap = SqlGenerateUtil.getNewFieldMap(SqlGenerateUtil.getField(entityObject));
        if (!SqlGenerateUtil.checkValueParams(fieldMap)) {
            throw new IllegalArgumentException("not entity bean.");
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        int field = 0;
        StringBuilder sql = new StringBuilder();
        Object[] params = new Object[fieldMap.size()];
        sql.append(" select * from ").append(tableName).append(" where 1=1 ");
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            params[field] = entry.getValue();
            sql.append(" and ").append(entry.getKey()).append("=? ");
            ++field;
        }
        queryMap.put("sql", sql.toString());
        queryMap.put("params", params);
        return queryMap;
    }

    public static Map<String, Object> getDeleteByPK(Object entityObject) throws Exception {
        String tableName = SqlGenerateUtil.getTableName(entityObject);
        String pk = SqlGenerateUtil.getPKname(entityObject);
        Object value = SqlGenerateUtil.getPKvalue(entityObject);
        if ("".equals(tableName.trim()) || pk == null || "".equals(pk) || value == null) {
            throw new IllegalArgumentException("not entity bean.");
        }
        String sql = " delete from " + tableName + " where " + pk + "=?";
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("sql", sql.toString());
        queryMap.put("params", new Object[]{value});
        return queryMap;
    }

    public static Map<String, Object> getUpdateByPK(boolean allField, Object entityObject) throws Exception {
        String tableName = SqlGenerateUtil.getTableName(entityObject);
        String pk = SqlGenerateUtil.getPKname(entityObject);
        Object value = SqlGenerateUtil.getPKvalue(entityObject);
        if ("".equals(tableName.trim()) || pk == null || "".equals(pk) || value == null) {
            throw new IllegalArgumentException("not entity bean.");
        }
        Map<String, Object> fieldMap = SqlGenerateUtil.getField(entityObject);
        if (!allField) {
            fieldMap = SqlGenerateUtil.getNewFieldMap(fieldMap);
        }
        fieldMap.remove(pk);
        if (!SqlGenerateUtil.checkValueParams(fieldMap)) {
            throw new IllegalArgumentException("not entity bean.");
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        int field = 0;
        StringBuilder sql = new StringBuilder();
        Object[] params = new Object[fieldMap.size() + 1];
        sql.append(" update ").append(tableName).append(" set ");
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            params[field] = entry.getValue();
            sql.append(" ").append(entry.getKey()).append("=?");
            if (++field >= fieldMap.size()) continue;
            sql.append(", ");
        }
        sql.append(" where ").append(pk).append("=?");
        params[field] = value;
        queryMap.put("sql", sql.toString());
        queryMap.put("params", params);
        return queryMap;
    }

    private static Map<String, Object> getNewFieldMap(Map<String, Object> fieldMap) throws Exception {
        HashMap<String, Object> newFieldMap = new HashMap<String, Object>();
        if (fieldMap == null || fieldMap.size() < 1) {
            return newFieldMap;
        }
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            if (entry.getValue() == null) continue;
            newFieldMap.put(entry.getKey(), entry.getValue());
        }
        return newFieldMap;
    }

    private static boolean checkValueParams(Map<String, Object> params) throws Exception {
        boolean status = false;
        if (params == null || params.size() < 1) {
            return status;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            status = true;
        }
        return status;
    }

    private static Map<String, Object> getByPK(String fieldName, Object entityObject) throws Exception {
        String tableName = SqlGenerateUtil.getTableName(entityObject);
        String pk = SqlGenerateUtil.getPKname(entityObject);
        Object value = SqlGenerateUtil.getPKvalue(entityObject);
        if ("".equals(tableName.trim()) || pk == null || "".equals(pk) || value == null) {
            throw new IllegalArgumentException("not entity bean.");
        }
        String sql = " select " + fieldName + " from " + tableName + " where " + pk + "=?";
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("sql", sql.toString());
        queryMap.put("params", new Object[]{value});
        return queryMap;
    }

    private static Map<String, Object> getByUK(String fieldName, Object entityObject) throws Exception {
        String tableName = SqlGenerateUtil.getTableName(entityObject);
        Map<String, Object> ukMap = SqlGenerateUtil.getUKParameter(entityObject);
        if ("".equals(tableName.trim()) || ukMap == null || ukMap.size() < 1) {
            throw new IllegalArgumentException("not entity bean.");
        }
        int field = 0;
        StringBuilder sql = new StringBuilder();
        Object[] params = new Object[ukMap.size()];
        sql.append(" select " + fieldName + " from " + tableName + " where 1=1 ");
        for (Map.Entry<String, Object> entry : ukMap.entrySet()) {
            params[field] = entry.getValue();
            sql.append(" and ").append(entry.getKey()).append("=? ");
            ++field;
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("sql", sql.toString());
        queryMap.put("params", params);
        return queryMap;
    }

    private static Map<String, Object> getUKParameter(Object entityObject) {
        Method[] methods = entityObject.getClass().getMethods();
        if (methods == null) {
            return null;
        }
        HashMap<String, Object> ukMap = new HashMap<String, Object>();
        int ix = 0;
        while (ix < methods.length) {
            Annotation[] annotations = methods[ix].getDeclaredAnnotations();
            if (annotations != null) {
                Annotation[] annotationArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation annotation = annotationArray[n2];
                    if (annotation instanceof EntityUK && methods[ix].getName().indexOf("get") == 0) {
                        int nx = 0;
                        while (nx < annotations.length) {
                            if (annotations[nx] instanceof Column) {
                                try {
                                    ukMap.put(((Column)annotations[nx]).name(), methods[ix].invoke(entityObject, new Object[0]));
                                    nx = annotations.length;
                                }
                                catch (IllegalArgumentException e) {
                                    e.printStackTrace();
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                            ++nx;
                        }
                    }
                    ++n2;
                }
            }
            ++ix;
        }
        return ukMap;
    }

    private static Object getPKvalue(Object entityObject) {
        Method[] methods = entityObject.getClass().getMethods();
        if (methods == null) {
            return null;
        }
        Object value = null;
        int ix = 0;
        while (ix < methods.length && value == null) {
            Annotation[] annotations = methods[ix].getDeclaredAnnotations();
            if (annotations != null) {
                Annotation[] annotationArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation annotation = annotationArray[n2];
                    if (annotation instanceof Id && methods[ix].getName().indexOf("get") == 0) {
                        try {
                            value = methods[ix].invoke(entityObject, new Object[0]);
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
            ++ix;
        }
        return value;
    }

    private static String getPKname(Object entityObject) {
        Method[] methods = entityObject.getClass().getMethods();
        Field[] fields = entityObject.getClass().getDeclaredFields();
        if (methods == null || fields == null) {
            return null;
        }
        String name = null;
        int ix = 0;
        while (ix < methods.length && name == null) {
            Annotation[] annotations = methods[ix].getDeclaredAnnotations();
            if (annotations != null) {
                int ax = 0;
                while (ax < annotations.length && name == null) {
                    if (annotations[ax] instanceof Id) {
                        int nx = 0;
                        while (nx < annotations.length && name == null) {
                            if (annotations[nx] instanceof Column && methods[ix].getName().indexOf("get") == 0) {
                                name = ((Column)annotations[nx]).name();
                            }
                            ++nx;
                        }
                    }
                    ++ax;
                }
            }
            ++ix;
        }
        return name;
    }

    private static Map<String, Object> getField(Object entityObject) throws Exception {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Method[] methods = entityObject.getClass().getMethods();
        int ix = 0;
        while (ix < methods.length) {
            Annotation[] annotations = methods[ix].getDeclaredAnnotations();
            if (annotations != null) {
                Annotation[] annotationArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    String column;
                    Annotation annotation = annotationArray[n2];
                    if (annotation instanceof Column && methods[ix].getName().indexOf("get") == 0 && !"".equals((column = StringUtils.defaultString(((Column)annotation).name())).trim())) {
                        Object value = methods[ix].invoke(entityObject, new Object[0]);
                        fieldMap.put(column, value);
                    }
                    ++n2;
                }
            }
            ++ix;
        }
        return fieldMap;
    }

    private static String getTableName(Object entityObject) throws Exception {
        Annotation[] annotations;
        String tableName = "";
        Annotation[] annotationArray = annotations = entityObject.getClass().getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof Table) {
                tableName = StringUtils.defaultString(((Table)annotation).name());
            }
            ++n2;
        }
        return tableName;
    }
}

