/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.base.interceptor;

import com.netsteadfast.greenstep.util.SimpleUtils;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="greenstep.web.interceptor.UserAgentRejectInterceptor")
@Scope(value="prototype")
public class UserAgentRejectInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -6402499430173243263L;
    protected Logger logger = Logger.getLogger(UserAgentRejectInterceptor.class);
    private static Properties props = new Properties();
    private static String[] rejectAgent = null;

    static {
        try {
            props.load(UserAgentRejectInterceptor.class.getClassLoader().getResource("META-INF/userAgentReject.properties").openStream());
            rejectAgent = SimpleUtils.getStr(props.getProperty("REJECT")).trim().split(",");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String intercept(ActionInvocation actionInvocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        String userAgent = SimpleUtils.getStr(request.getHeader("User-Agent")).toUpperCase();
        if (rejectAgent == null) {
            return actionInvocation.invoke();
        }
        int i = 0;
        while (rejectAgent != null && i < rejectAgent.length) {
            if (!rejectAgent[i].trim().equals("") && userAgent.indexOf(rejectAgent[i]) > -1) {
                HashMap<String, String> valueStackMap = new HashMap<String, String>();
                valueStackMap.put("errorMessage", "not supported " + userAgent);
                valueStackMap.put("pageMessage", "not supported " + userAgent);
                ActionContext.getContext().getValueStack().push(valueStackMap);
                this.logger.warn("reject User-Agent=" + userAgent);
                return "rejectUserAgent";
            }
            ++i;
        }
        return actionInvocation.invoke();
    }
}

