/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.scripting.secure.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.ScriptTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.scripting.secure.impl.SecureJavascriptUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureJavascriptTaskActivityBehavior
extends ScriptTaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureJavascriptTaskActivityBehavior.class);

    public SecureJavascriptTaskActivityBehavior(String scriptTaskId, String script, String language, String resultVariable, boolean storeScriptVariables) {
        super(scriptTaskId, script, language, resultVariable, storeScriptVariables);
    }

    public void execute(DelegateExecution execution) {
        String overrideScript;
        ObjectNode taskElementProperties;
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache() && (taskElementProperties = Context.getBpmnOverrideElementProperties((String)this.scriptTaskId, (String)execution.getProcessDefinitionId())) != null && taskElementProperties.has("scriptTaskScript") && StringUtils.isNotEmpty((CharSequence)(overrideScript = taskElementProperties.get("scriptTaskScript").asText())) && !overrideScript.equals(this.script)) {
            this.script = overrideScript;
        }
        boolean noErrors = true;
        try {
            Object result = SecureJavascriptUtil.evaluateScript((VariableScope)execution, this.script, config.getBeans());
            if (this.resultVariable != null) {
                execution.setVariable(this.resultVariable, result);
            }
        }
        catch (ActivitiException e) {
            LOGGER.warn("Exception while executing " + execution.getCurrentActivityId() + " : " + e.getMessage());
            noErrors = false;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)((BpmnError)rootCause), (DelegateExecution)execution);
            }
            throw e;
        }
        if (noErrors) {
            this.leave(execution);
        }
    }
}

