/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.olap4j.Axis;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.pivot4j.PivotException;
import org.pivot4j.util.MemberHierarchyCache;

public class OlapUtils {
    private Cube cube;
    private MemberHierarchyCache memberHierarchyCache;

    public OlapUtils(Cube cube) {
        if (cube == null) {
            throw new NullArgumentException("cube");
        }
        this.cube = cube;
    }

    public Cube getCube() {
        return this.cube;
    }

    public MemberHierarchyCache getMemberHierarchyCache() {
        return this.memberHierarchyCache;
    }

    public void setMemberHierarchyCache(MemberHierarchyCache memberHierarchyCache) {
        this.memberHierarchyCache = memberHierarchyCache;
    }

    public Member lookupMember(String identifier) {
        return OlapUtils.lookupMember(identifier, this.cube);
    }

    public static Member lookupMember(String identifier, Cube cube) {
        try {
            return cube.lookupMember(IdentifierNode.parseIdentifier((String)identifier).getSegmentList());
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
    }

    public static boolean isVisible(Member member) {
        try {
            if (member.getDimension().getDimensionType() == Dimension.Type.MEASURE) {
                return member.isVisible();
            }
        }
        catch (OlapException e) {
            throw new PivotException(e);
        }
        return true;
    }

    public static boolean equals(MetadataElement elem, MetadataElement otherElem) {
        if (elem == null) {
            return otherElem == null;
        }
        if (otherElem == null) {
            return false;
        }
        String uniqueName = elem.getUniqueName();
        String otherUniqueName = otherElem.getUniqueName();
        return ObjectUtils.equals((Object)uniqueName, (Object)otherUniqueName);
    }

    public static boolean equals(Position position, Position otherPosition) {
        return OlapUtils.equals(position, otherPosition, -1);
    }

    public static boolean equals(Position position, Position otherPosition, int memberIndex) {
        if (position == otherPosition) {
            return true;
        }
        if (position == null || otherPosition == null) {
            return false;
        }
        int size = position.getMembers().size();
        if (memberIndex < 0) {
            memberIndex = size;
            if (size != otherPosition.getMembers().size()) {
                return false;
            }
        }
        for (int i = 0; i < memberIndex; ++i) {
            Member lastMember;
            Member member = (Member)position.getMembers().get(i);
            if (OlapUtils.equals((MetadataElement)member, (MetadataElement)(lastMember = (Member)otherPosition.getMembers().get(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Axis axis, Axis otherAxis) {
        if (axis == otherAxis) {
            return true;
        }
        if (axis == null || otherAxis == null) {
            return false;
        }
        return axis.axisOrdinal() == otherAxis.axisOrdinal();
    }

    private Member getParentMember(Member member) {
        Member parent = this.memberHierarchyCache == null ? member.getParentMember() : this.memberHierarchyCache.getParentMember(member);
        return parent;
    }

    private boolean isRaggedMember(Member member) {
        if (member instanceof RaggedMemberWrapper) {
            return true;
        }
        Member parent = this.getParentMember(member);
        return member.getDepth() > 1 && parent == null;
    }

    private boolean hasRaggedParent(Member member) {
        if (member instanceof RaggedMemberWrapper) {
            return true;
        }
        Member parent = member;
        while ((parent = this.getParentMember(parent)) != null) {
            if (!this.isRaggedMember(parent)) continue;
            return true;
        }
        return false;
    }

    public Member wrapRaggedIfNecessary(Member member) {
        if (member == null) {
            throw new NullArgumentException("member");
        }
        if (member instanceof RaggedMemberWrapper || !this.isRaggedMember(member) && !this.hasRaggedParent(member)) {
            return member;
        }
        return new RaggedMemberWrapper(member, this.cube);
    }

    public List<Member> wrapRaggedIfNecessary(List<Member> members) {
        if (members == null) {
            throw new NullArgumentException("members");
        }
        ArrayList<Member> wrappedMembers = new ArrayList<Member>(members.size());
        for (Member member : members) {
            wrappedMembers.add(this.wrapRaggedIfNecessary(member));
        }
        return wrappedMembers;
    }

    public Member getTopLevelRaggedMember(Member member) {
        if (member == null) {
            throw new NullArgumentException("member");
        }
        Member topMember = member instanceof RaggedMemberWrapper ? ((RaggedMemberWrapper)member).getTopMember() : this.getParentMember(member);
        return topMember;
    }

    public Member getBaseRaggedMember(Member member) {
        if (member == null) {
            throw new NullArgumentException("member");
        }
        Member baseMember = member instanceof RaggedMemberWrapper ? ((RaggedMemberWrapper)member).getBaseMember() : member;
        return baseMember;
    }

    public static boolean isEmptySetSupported(OlapDatabaseMetaData metadata) {
        try {
            String driverName = metadata.getDriverName().toLowerCase();
            if (driverName.contains("xmla") || driverName.contains("xml/a")) {
                return !metadata.getDatabaseProductName().toLowerCase().contains("mondrian");
            }
        }
        catch (SQLException e) {
            throw new PivotException(e);
        }
        return true;
    }

    static class RaggedMemberWrapper
    implements Member,
    Named {
        private String uniqueName;
        private List<Member> ancestors;
        private Member baseMember;
        private Member topMember;
        private NamedList<RaggedMemberWrapper> children;
        private Level level;

        RaggedMemberWrapper(Member member, Cube cube) {
            this.baseMember = member;
            this.level = member.getLevel();
            this.ancestors = new LinkedList<Member>();
            List<IdentifierSegment> segments = Collections.unmodifiableList(IdentifierParser.parseIdentifier((String)member.getUniqueName()));
            LinkedList<IdentifierSegment> resolvableSegments = new LinkedList<IdentifierSegment>();
            int i = 0;
            int count = segments.size();
            NamedList levels = member.getHierarchy().getLevels();
            for (IdentifierSegment segment : segments) {
                Member ancestor;
                resolvableSegments.add(segment);
                Level currentLevel = (Level)levels.get(i);
                try {
                    ancestor = cube.lookupMember(resolvableSegments);
                    if (ancestor == null && i == 0) {
                        ancestor = member.getHierarchy().getDefaultMember();
                    }
                }
                catch (OlapException e) {
                    throw new PivotException(e);
                }
                if (i == 0 && ancestor == null) {
                    throw new PivotException("Can't determine top level parent for the ragged member : " + member.getUniqueName());
                }
                if (++i >= count) {
                    this.uniqueName = RaggedMemberWrapper.getUniqueName(resolvableSegments);
                    continue;
                }
                if (ancestor == null) {
                    String currentName = RaggedMemberWrapper.getUniqueName(segments.subList(0, i));
                    ancestor = new RaggedMemberWrapper(currentName, currentLevel, new LinkedList<Member>(this.ancestors), this.baseMember, this.topMember);
                    this.ancestors.add(0, ancestor);
                    resolvableSegments.remove(segment);
                    continue;
                }
                this.ancestors.add(0, ancestor);
                this.topMember = ancestor;
            }
            if (this.topMember == null) {
                throw new IllegalArgumentException("Unable to find a non-ragged ancestor of the specified member : " + member);
            }
        }

        RaggedMemberWrapper(String uniqueName, Level level, List<Member> ancestors, Member baseMember, Member topMember) {
            this.uniqueName = uniqueName;
            this.level = level;
            this.baseMember = baseMember;
            this.topMember = topMember;
            this.ancestors = ancestors;
            this.children = new NamedListImpl();
        }

        private static String getUniqueName(List<IdentifierSegment> segments) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (IdentifierSegment segment : segments) {
                if (first) {
                    first = false;
                } else {
                    builder.append(".");
                }
                builder.append(segment.toString());
            }
            return builder.toString();
        }

        public Member getBaseMember() {
            return this.baseMember;
        }

        public Member getTopMember() {
            return this.topMember;
        }

        protected boolean isBaseMember() {
            return this.level.getDepth() == this.baseMember.getDepth();
        }

        public String getName() {
            if (this.isBaseMember()) {
                return this.baseMember.getName();
            }
            return "";
        }

        public String getUniqueName() {
            return this.uniqueName;
        }

        public String getCaption() {
            if (this.isBaseMember()) {
                return this.baseMember.getCaption();
            }
            return "";
        }

        public String getDescription() {
            if (this.isBaseMember()) {
                return this.baseMember.getDescription();
            }
            return "";
        }

        public NamedList<? extends Member> getChildMembers() throws OlapException {
            if (this.isBaseMember()) {
                return this.baseMember.getChildMembers();
            }
            return this.children;
        }

        public int getChildMemberCount() throws OlapException {
            if (this.isBaseMember()) {
                return this.baseMember.getChildMemberCount();
            }
            return 1;
        }

        public Member getParentMember() {
            if (this.ancestors.isEmpty()) {
                return null;
            }
            return this.ancestors.get(0);
        }

        public List<Member> getAncestorMembers() {
            return this.ancestors;
        }

        public Level getLevel() {
            return this.level;
        }

        public Hierarchy getHierarchy() {
            return this.baseMember.getHierarchy();
        }

        public Dimension getDimension() {
            return this.baseMember.getDimension();
        }

        public Member.Type getMemberType() {
            if (this.isBaseMember()) {
                return this.baseMember.getMemberType();
            }
            return Member.Type.UNKNOWN;
        }

        public boolean isAll() {
            return false;
        }

        public boolean isChildOrEqualTo(Member member) {
            if (this.isBaseMember()) {
                return this.baseMember.isChildOrEqualTo(member);
            }
            if (!(member instanceof RaggedMemberWrapper)) {
                return false;
            }
            RaggedMemberWrapper other = (RaggedMemberWrapper)member;
            return OlapUtils.equals((MetadataElement)this.baseMember, (MetadataElement)other.baseMember) && this.level.getDepth() <= other.level.getDepth();
        }

        public ParseTreeNode getExpression() {
            if (this.isBaseMember()) {
                return this.baseMember.getExpression();
            }
            return null;
        }

        public boolean isCalculated() {
            return false;
        }

        public boolean isCalculatedInQuery() {
            return false;
        }

        public int getSolveOrder() {
            if (this.isBaseMember()) {
                return this.baseMember.getSolveOrder();
            }
            return 0;
        }

        public Object getPropertyValue(Property property) throws OlapException {
            if (this.isBaseMember()) {
                return this.baseMember.getPropertyValue(property);
            }
            return null;
        }

        public String getPropertyFormattedValue(Property property) throws OlapException {
            if (this.isBaseMember()) {
                return this.baseMember.getPropertyFormattedValue(property);
            }
            return null;
        }

        public void setProperty(Property property, Object value) throws OlapException {
            if (!this.isBaseMember()) {
                throw new UnsupportedOperationException();
            }
            this.baseMember.setProperty(property, value);
        }

        public NamedList<Property> getProperties() {
            if (this.isBaseMember()) {
                return this.baseMember.getProperties();
            }
            return new NamedListImpl();
        }

        public int getOrdinal() {
            if (this.isBaseMember()) {
                return this.baseMember.getOrdinal();
            }
            return 0;
        }

        public boolean isVisible() {
            return this.baseMember.isVisible();
        }

        public boolean isHidden() {
            return this.baseMember.isHidden();
        }

        public int getDepth() {
            return this.level.getDepth();
        }

        public Member getDataMember() {
            return this;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getUniqueName()).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Member)) {
                return false;
            }
            Member other = (Member)obj;
            if (this.isBaseMember() && OlapUtils.equals((MetadataElement)this.baseMember, (MetadataElement)other)) {
                return true;
            }
            return OlapUtils.equals((MetadataElement)this, (MetadataElement)other);
        }

        public String toString() {
            return this.getUniqueName();
        }
    }
}

