/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.util;

import freemarker.template.utility.NullArgumentException;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Member;
import org.pivot4j.util.Cache;
import org.pivot4j.util.OlapUtils;

public class MemberHierarchyCache
extends Cache<String, Member> {
    private Cube cube;
    private OlapUtils util;

    public MemberHierarchyCache(Cube cube) {
        if (cube == null) {
            throw new NullArgumentException("cube");
        }
        this.cube = cube;
        this.util = new OlapUtils(cube);
        this.util.setMemberHierarchyCache(this);
    }

    public Cube getCube() {
        return this.cube;
    }

    public Member getParentMember(Member member) {
        if (member == null) {
            throw new NullArgumentException("member");
        }
        Member parent = (Member)this.get(member.getUniqueName());
        if (parent == null) {
            parent = member.getParentMember();
            if (parent != null) {
                parent = this.util.wrapRaggedIfNecessary(parent);
            }
            this.put(member.getUniqueName(), parent);
        }
        return parent;
    }

    public List<Member> getAncestorMembers(Member member) {
        if (member == null) {
            throw new NullArgumentException("member");
        }
        ArrayList<Member> ancestors = new ArrayList<Member>();
        Member parent = member;
        while ((parent = this.getParentMember(parent)) != null) {
            ancestors.add(parent);
        }
        return ancestors;
    }
}

