/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.util;

import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;

public class Cache<K, V> {
    private Map<K, V> data = new ReferenceMap();
    private Cache<K, V> parent;

    public Cache() {
    }

    public Cache(Cache<K, V> parent) {
        this.parent = parent;
    }

    public Cache<K, V> getParent() {
        return this.parent;
    }

    public void clear() {
        this.data.clear();
        if (this.parent != null) {
            this.parent.clear();
        }
    }

    public boolean containsKey(K key) {
        return this.data.containsKey(key) || this.parent != null && this.parent.containsKey(key);
    }

    public V get(K key) {
        V result = this.data.get(key);
        if (result == null && this.parent != null) {
            result = this.parent.get(key);
        }
        return result;
    }

    public void put(K key, V value) {
        if (value == null) {
            this.remove(key);
        } else {
            this.data.put(key, value);
        }
    }

    public void remove(K key) {
        this.data.remove(key);
        if (this.parent != null) {
            this.parent.remove(key);
        }
    }
}

