/*
 * Decompiled with CFR 0.152.
 */
package org.pivot4j.ui.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapException;
import org.olap4j.Position;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.Property;
import org.pivot4j.PivotException;
import org.pivot4j.PivotModel;
import org.pivot4j.impl.PivotModelImpl;
import org.pivot4j.transform.ChangeSlicer;
import org.pivot4j.ui.AbstractPivotRenderer;
import org.pivot4j.ui.aggregator.Aggregator;
import org.pivot4j.ui.aggregator.AggregatorFactory;
import org.pivot4j.ui.aggregator.AggregatorPosition;
import org.pivot4j.ui.table.TableAxisContext;
import org.pivot4j.ui.table.TableHeaderNode;
import org.pivot4j.ui.table.TableRenderCallback;
import org.pivot4j.ui.table.TableRenderContext;
import org.pivot4j.util.MemberHierarchyCache;
import org.pivot4j.util.MemberSelection;
import org.pivot4j.util.OlapUtils;
import org.pivot4j.util.TreeNode;
import org.pivot4j.util.TreeNodeCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRenderer
extends AbstractPivotRenderer<TableRenderContext, TableRenderCallback> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean hideSpans = false;
    private boolean showParentMembers = false;
    private boolean showDimensionTitle = true;
    private boolean showSlicerMembersInline = true;
    private Comparator<Level> levelComparator = new Comparator<Level>(){

        @Override
        public int compare(Level l1, Level l2) {
            Integer d1 = l1.getDepth();
            Integer d2 = l2.getDepth();
            return d1.compareTo(d2);
        }
    };

    @Override
    protected List<String> getRenderPropertyCategories() {
        LinkedList<String> categories = new LinkedList<String>(super.getRenderPropertyCategories());
        categories.add("cell");
        categories.add("header");
        return categories;
    }

    public boolean getHideSpans() {
        return this.hideSpans;
    }

    public void setHideSpans(boolean hideSpans) {
        this.hideSpans = hideSpans;
    }

    public boolean getShowParentMembers() {
        return this.showParentMembers;
    }

    public void setShowParentMembers(boolean showParentMembers) {
        this.showParentMembers = showParentMembers;
    }

    public boolean getShowDimensionTitle() {
        return this.showDimensionTitle;
    }

    public void setShowDimensionTitle(boolean showDimensionTitle) {
        this.showDimensionTitle = showDimensionTitle;
    }

    public boolean getShowSlicerMembersInline() {
        return this.showSlicerMembersInline;
    }

    public void setShowSlicerMembersInline(boolean showSlicerMembersInline) {
        this.showSlicerMembersInline = showSlicerMembersInline;
    }

    public void swapAxes() {
        for (AggregatorPosition position : AggregatorPosition.values()) {
            this.swapAggregators(position);
        }
    }

    private void swapAggregators(AggregatorPosition position) {
        List<String> aggregators = this.getAggregators((Axis)Axis.COLUMNS, position);
        this.setAggregators((Axis)Axis.COLUMNS, position, this.getAggregators((Axis)Axis.ROWS, position));
        this.setAggregators((Axis)Axis.ROWS, position, aggregators);
    }

    @Override
    protected String getLabel(TableRenderContext context) {
        String label = "label".equals(context.getCellType()) ? this.getHeaderLabel(context) : ("title".equals(context.getCellType()) ? this.getTitleLabel(context) : ("value".equals(context.getCellType()) ? this.getValueLabel(context) : ("aggValue".equals(context.getCellType()) ? this.getAggregationLabel(context) : null)));
        return label;
    }

    @Override
    protected Double getValue(TableRenderContext context) {
        Double value;
        block5: {
            value = null;
            Aggregator aggregator = context.getAggregator();
            Cell cell = context.getCell();
            try {
                if (aggregator == null) {
                    if (cell == null || cell.isEmpty()) break block5;
                    try {
                        value = cell.getDoubleValue();
                        break block5;
                    }
                    catch (OlapException e) {
                        throw new PivotException(e);
                    }
                }
                value = aggregator.getValue(context);
            }
            catch (NumberFormatException e) {
                if (!this.logger.isTraceEnabled()) break block5;
                this.logger.trace("Non-numeric cell value : {}", cell.getValue());
            }
        }
        return value;
    }

    protected String getHeaderLabel(TableRenderContext context) {
        String label;
        if (context.getProperty() == null) {
            label = context.getMember() == null ? context.getHierarchy().getCaption() : context.getMember().getCaption();
        } else {
            try {
                label = context.getMember().getPropertyFormattedValue(context.getProperty());
            }
            catch (OlapException e) {
                throw new PivotException(e);
            }
        }
        return label;
    }

    protected String getTitleLabel(TableRenderContext context) {
        String label = null;
        if (context.getProperty() != null) {
            label = context.getProperty().getCaption();
        } else if (context.getLevel() != null) {
            label = context.getLevel().getCaption();
        } else if (context.getHierarchy() != null) {
            label = context.getHierarchy().getCaption();
        }
        return label;
    }

    protected String getValueLabel(TableRenderContext context) {
        Aggregator aggregator;
        Cell cell = context.getCell();
        Object label = cell == null ? (context.getAxis() == Axis.FILTER ? (context.getMember() != null ? context.getMember().getCaption() : context.getHierarchy().getCaption()) : ((aggregator = context.getAggregator()) == null ? null : aggregator.getFormattedValue(context))) : cell.getFormattedValue();
        return label;
    }

    protected String getAggregationLabel(TableRenderContext context) {
        Aggregator aggregator = context.getAggregator();
        String label = aggregator == null && context.getMember() != null ? context.getMember().getCaption() : aggregator.getLabel(context);
        return label;
    }

    @Override
    protected String getRenderPropertyCategory(TableRenderContext context) {
        String category = "value".equals(context.getCellType()) || "aggValue".equals(context.getCellType()) ? "cell" : "header";
        return category;
    }

    @Override
    public Serializable saveState() {
        Serializable[] states = new Serializable[7];
        int index = 0;
        states[index++] = super.saveState();
        states[index++] = Boolean.valueOf(this.showParentMembers);
        states[index++] = Boolean.valueOf(this.showDimensionTitle);
        states[index++] = Boolean.valueOf(this.hideSpans);
        states[index++] = Boolean.valueOf(this.showSlicerMembersInline);
        return states;
    }

    @Override
    public void restoreState(Serializable state) {
        if (state == null) {
            throw new NullArgumentException("state");
        }
        Serializable[] states = (Serializable[])state;
        int index = 0;
        super.restoreState(states[index++]);
        this.showParentMembers = (Boolean)states[index++];
        this.showDimensionTitle = (Boolean)states[index++];
        this.hideSpans = (Boolean)states[index++];
        this.showSlicerMembersInline = (Boolean)states[index++];
    }

    @Override
    public void saveSettings(HierarchicalConfiguration configuration) {
        super.saveSettings(configuration);
        configuration.addProperty("showDimensionTitle", (Object)this.showDimensionTitle);
        configuration.addProperty("showParentMembers", (Object)this.showParentMembers);
        configuration.addProperty("hideSpans", (Object)this.hideSpans);
        configuration.addProperty("filter[@inline]", (Object)this.showSlicerMembersInline);
    }

    @Override
    public void restoreSettings(HierarchicalConfiguration configuration) {
        super.restoreSettings(configuration);
        this.showDimensionTitle = configuration.getBoolean("showDimensionTitle", true);
        this.showParentMembers = configuration.getBoolean("showParentMembers", false);
        this.hideSpans = configuration.getBoolean("hideSpans", false);
        this.showSlicerMembersInline = configuration.getBoolean("filter[@inline]", true);
    }

    @Override
    public void render(PivotModel model, TableRenderCallback callback) {
        if (model == null) {
            throw new NullArgumentException("model");
        }
        if (callback == null) {
            throw new NullArgumentException("callback");
        }
        CellSet cellSet = model.getCellSet();
        if (cellSet == null) {
            return;
        }
        List axes = cellSet.getAxes();
        if (axes.isEmpty()) {
            return;
        }
        MemberHierarchyCache cache = model instanceof PivotModelImpl ? ((PivotModelImpl)model).getMemberHierarchyCache() : new MemberHierarchyCache(model.getCube());
        TableHeaderNode columnRoot = this.createAxisTree(model, (Axis)Axis.COLUMNS, cache);
        if (columnRoot == null) {
            return;
        }
        TableHeaderNode rowRoot = this.createAxisTree(model, (Axis)Axis.ROWS, cache);
        if (rowRoot == null) {
            return;
        }
        List<Object> filterRoots = this.getRenderSlicer() ? this.createFilterAxisTrees(model, cache) : Collections.emptyList();
        this.configureAxisTree(model, (Axis)Axis.COLUMNS, columnRoot);
        this.configureAxisTree(model, (Axis)Axis.ROWS, rowRoot);
        for (TableHeaderNode tableHeaderNode : filterRoots) {
            this.configureAxisTree(model, (Axis)Axis.FILTER, tableHeaderNode);
        }
        this.invalidateAxisTree(model, (Axis)Axis.COLUMNS, columnRoot);
        this.invalidateAxisTree(model, (Axis)Axis.ROWS, rowRoot);
        for (TableHeaderNode tableHeaderNode : filterRoots) {
            this.invalidateAxisTree(model, (Axis)Axis.FILTER, tableHeaderNode);
        }
        TableRenderContext context = this.createRenderContext(model, columnRoot, rowRoot);
        callback.startRender(context);
        callback.startTable(context);
        this.renderHeader(context, columnRoot, rowRoot, callback);
        this.renderBody(context, columnRoot, rowRoot, callback);
        callback.endTable(context);
        for (TableHeaderNode tableHeaderNode : filterRoots) {
            this.renderFilter(context, tableHeaderNode, callback);
        }
        callback.endRender(context);
    }

    protected TableRenderContext createRenderContext(PivotModel model, TableHeaderNode columnRoot, TableHeaderNode rowRoot) {
        int columnHeaderCount = columnRoot.getMaxRowIndex();
        int rowHeaderCount = rowRoot.getMaxRowIndex();
        int columnCount = columnRoot.getWidth();
        int rowCount = rowRoot.getWidth();
        TableRenderContext context = new TableRenderContext(model, this, columnCount, rowCount, columnHeaderCount, rowHeaderCount);
        return context;
    }

    protected void renderHeader(final TableRenderContext context, TableHeaderNode columnRoot, TableHeaderNode rowRoot, final TableRenderCallback callback) {
        callback.startHeader(context);
        context.setRenderPropertyCategory("header");
        int count = context.getColumnHeaderCount();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            context.setAxis((Axis)Axis.COLUMNS);
            context.setColIndex(0);
            context.setRowIndex(rowIndex);
            callback.startRow(context);
            this.renderHeaderCorner(context, columnRoot, rowRoot, callback);
            context.setAxis((Axis)Axis.COLUMNS);
            columnRoot.walkChildrenAtRowIndex(new TreeNodeCallback<TableAxisContext>(){

                @Override
                public int handleTreeNode(TreeNode<TableAxisContext> node) {
                    TableHeaderNode headerNode = (TableHeaderNode)node;
                    context.setColIndex(headerNode.getColIndex() + context.getRowHeaderCount());
                    context.setColSpan(headerNode.getColSpan());
                    context.setRowSpan(headerNode.getRowSpan());
                    context.setMember(headerNode.getMember());
                    context.setProperty(headerNode.getProperty());
                    context.setHierarchy(headerNode.getHierarchy());
                    context.setPosition(headerNode.getPosition());
                    context.setColumnPosition(headerNode.getPosition());
                    context.setAggregator(headerNode.getAggregator());
                    context.setCell(null);
                    if (headerNode.isAggregation()) {
                        context.setCellType("aggValue");
                    } else if (context.getMember() == null) {
                        if (context.getHierarchy() == null) {
                            context.setCellType("fill");
                        } else {
                            context.setCellType("title");
                        }
                    } else {
                        context.setCellType("label");
                    }
                    callback.startCell(context);
                    callback.renderCommands(context, TableRenderer.this.getCommands(context));
                    callback.renderContent(context, TableRenderer.this.getLabel(context), TableRenderer.this.getValue(context));
                    callback.endCell(context);
                    return 0;
                }
            }, rowIndex + 1);
            callback.endRow(context);
        }
        callback.endHeader(context);
    }

    protected void renderBody(final TableRenderContext context, final TableHeaderNode columnRoot, final TableHeaderNode rowRoot, final TableRenderCallback callback) {
        callback.startBody(context);
        int count = rowRoot.getColSpan();
        for (int rowIndex = 0; rowIndex < count; ++rowIndex) {
            context.setAxis((Axis)Axis.ROWS);
            context.setColIndex(0);
            context.setRowIndex(rowIndex + context.getColumnHeaderCount());
            callback.startRow(context);
            rowRoot.walkChildrenAtColIndex(new TreeNodeCallback<TableAxisContext>(){

                @Override
                public int handleTreeNode(TreeNode<TableAxisContext> node) {
                    TableHeaderNode headerNode = (TableHeaderNode)node;
                    if (headerNode.getRowIndex() == 0) {
                        return 0;
                    }
                    context.setColIndex(headerNode.getRowIndex() - 1);
                    context.setColSpan(headerNode.getRowSpan());
                    context.setRowSpan(headerNode.getColSpan());
                    context.setMember(headerNode.getMember());
                    context.setLevel(headerNode.getMemberLevel());
                    context.setProperty(headerNode.getProperty());
                    context.setHierarchy(headerNode.getHierarchy());
                    context.setPosition(headerNode.getPosition());
                    context.setRowPosition(headerNode.getPosition());
                    context.setAggregator(headerNode.getAggregator());
                    context.setCell(null);
                    context.setRenderPropertyCategory("header");
                    if (headerNode.isAggregation()) {
                        context.setCellType("aggValue");
                    } else if (context.getMember() == null) {
                        if (context.getHierarchy() == null) {
                            context.setCellType("fill");
                        } else {
                            context.setCellType("title");
                        }
                    } else {
                        context.setCellType("label");
                    }
                    callback.startCell(context);
                    callback.renderCommands(context, TableRenderer.this.getCommands(context));
                    callback.renderContent(context, TableRenderer.this.getLabel(context), TableRenderer.this.getValue(context));
                    callback.endCell(context);
                    if (headerNode.getChildCount() == 0) {
                        TableRenderer.this.renderDataRow(context, columnRoot, rowRoot, (TableHeaderNode)node, callback);
                    }
                    return 0;
                }
            }, rowIndex);
            callback.endRow(context);
        }
        callback.endBody(context);
    }

    protected void renderDataRow(TableRenderContext context, TableHeaderNode columnRoot, TableHeaderNode rowRoot, TableHeaderNode rowNode, TableRenderCallback callback) {
        context.setCellType("value");
        context.setRenderPropertyCategory("cell");
        for (int i = 0; i < context.getColumnCount(); ++i) {
            Cell cell = null;
            TableHeaderNode columnNode = columnRoot.getLeafNodeAtColIndex(i);
            if (columnNode != null && columnNode.getPosition() != null && columnNode.getPosition().getOrdinal() != -1 && rowNode.getPosition() != null && rowNode.getPosition().getOrdinal() != -1) {
                cell = context.getCellSet().getCell(new Position[]{columnNode.getPosition(), rowNode.getPosition()});
            }
            context.setColIndex(context.getRowHeaderCount() + i);
            context.setColSpan(1);
            context.setRowSpan(1);
            context.setAggregator(null);
            context.setAxis(null);
            context.setHierarchy(null);
            context.setLevel(null);
            context.setMember(null);
            context.setCell(cell);
            context.setPosition(null);
            context.setColumnPosition(columnNode.getPosition());
            context.setRowPosition(rowNode.getPosition());
            if (columnNode.getAggregator() == null) {
                if (rowNode.getAggregator() != null) {
                    context.setAggregator(rowNode.getAggregator());
                    context.setAxis((Axis)Axis.ROWS);
                }
            } else if (rowNode.getAggregator() == null || columnNode.getAggregator().getMeasure() != null) {
                context.setAggregator(columnNode.getAggregator());
                context.setAxis((Axis)Axis.COLUMNS);
            } else if (rowNode.getAggregator().getMeasure() != null) {
                context.setAggregator(rowNode.getAggregator());
                context.setAxis((Axis)Axis.ROWS);
            }
            callback.startCell(context);
            callback.renderCommands(context, this.getCommands(context));
            callback.renderContent(context, this.getLabel(context), this.getValue(context));
            callback.endCell(context);
            context.setPosition(context.getRowPosition());
            for (AggregatorPosition position : AggregatorPosition.values()) {
                for (Aggregator aggregator : ((TableAxisContext)rowRoot.getReference()).getAggregators(position)) {
                    this.aggregate(context, rowNode, aggregator, position);
                }
            }
            context.setPosition(context.getColumnPosition());
            for (AggregatorPosition position : AggregatorPosition.values()) {
                for (Aggregator aggregator : ((TableAxisContext)columnRoot.getReference()).getAggregators(position)) {
                    this.aggregate(context, columnNode, aggregator, position);
                }
            }
        }
        context.setAggregator(null);
    }

    protected void aggregate(TableRenderContext context, TableHeaderNode node, Aggregator aggregator, AggregatorPosition position) {
        Member member;
        Measure measure = aggregator.getMeasure();
        List<Member> members = aggregator.getMembers();
        if (context.getCell() == null && (measure == null || context.getAggregator() == null)) {
            return;
        }
        if (context.getAggregator() != null && context.getAggregator().getAxis() == aggregator.getAxis()) {
            return;
        }
        MemberHierarchyCache cache = ((TableAxisContext)node.getReference()).getMemberHierarchyCache();
        List positionMembers = context.getPosition().getMembers();
        OlapUtils utils = new OlapUtils(context.getModel().getCube());
        utils.setMemberHierarchyCache(cache);
        int index = 0;
        for (Member member2 : members) {
            if (positionMembers.size() <= index) {
                return;
            }
            Member positionMember = utils.wrapRaggedIfNecessary((Member)positionMembers.get(index));
            if (!(OlapUtils.equals((MetadataElement)member2, (MetadataElement)positionMember) || member2.getDepth() < positionMember.getDepth() && cache.getAncestorMembers(positionMember).contains(member2))) {
                return;
            }
            ++index;
        }
        if (measure != null && !positionMembers.isEmpty() && !measure.equals(member = (Member)positionMembers.get(positionMembers.size() - 1))) {
            return;
        }
        block6: for (TableHeaderNode parent = node; parent != null; parent = (TableHeaderNode)parent.getParent()) {
            if (parent.getHierarchyDescendents() != 1 || parent.getMemberChildren() <= 0) continue;
            switch (position) {
                case Grand: {
                    return;
                }
                case Hierarchy: {
                    if (members.contains(parent.getMember())) continue block6;
                    return;
                }
                case Member: {
                    if (node != parent && members.lastIndexOf(parent.getMember()) != members.size() - 1) continue block6;
                    return;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
        aggregator.aggregate(context);
    }

    protected void renderHeaderCorner(TableRenderContext context, TableHeaderNode columnRoot, TableHeaderNode rowRoot, TableRenderCallback callback) {
        boolean renderLevelTitle;
        int offset = 0;
        if (this.getShowDimensionTitle()) {
            offset = this.showParentMembers ? 2 : 1;
        }
        context.setAxis(null);
        context.setHierarchy(null);
        context.setLevel(null);
        context.setMember(null);
        context.setProperty(null);
        context.setCell(null);
        context.setCellType("fill");
        context.setPosition(null);
        context.setColumnPosition(null);
        context.setRowPosition(null);
        boolean renderDimensionTitle = this.showDimensionTitle && context.getRowIndex() == context.getColumnHeaderCount() - offset;
        boolean bl = renderLevelTitle = this.showDimensionTitle && this.showParentMembers && context.getRowIndex() == context.getColumnHeaderCount() - 1;
        if (context.getRowIndex() == 0 && !renderDimensionTitle && !renderLevelTitle) {
            context.setColSpan(context.getRowHeaderCount());
            context.setRowSpan(context.getColumnHeaderCount() - offset);
            callback.startCell(context);
            callback.renderCommands(context, this.getCommands(context));
            callback.renderContent(context, this.getLabel(context), this.getValue(context));
            callback.endCell(context);
        } else if (renderDimensionTitle) {
            final HashMap spans = new HashMap();
            final HashMap propertyMap = new HashMap();
            rowRoot.walkChildrenAtColIndex(new TreeNodeCallback<TableAxisContext>(){

                @Override
                public int handleTreeNode(TreeNode<TableAxisContext> node) {
                    TableHeaderNode headerNode = (TableHeaderNode)node;
                    if (headerNode.getHierarchy() == null) {
                        return 0;
                    }
                    Hierarchy hierarchy = headerNode.getHierarchy();
                    if (headerNode.getProperty() == null) {
                        Integer span = (Integer)spans.get(hierarchy);
                        if (span == null) {
                            span = 0;
                        }
                        span = span + headerNode.getRowSpan();
                        spans.put(headerNode.getHierarchy(), span);
                    } else {
                        ArrayList<Property> properties = (ArrayList<Property>)propertyMap.get(hierarchy);
                        if (properties == null) {
                            properties = new ArrayList<Property>();
                            propertyMap.put(hierarchy, properties);
                        }
                        properties.add(headerNode.getProperty());
                    }
                    return 0;
                }
            }, 0);
            context.setAxis((Axis)Axis.ROWS);
            context.setRowSpan(1);
            context.setCellType("title");
            for (Hierarchy hierarchy : ((TableAxisContext)rowRoot.getReference()).getHierarchies()) {
                Integer span = (Integer)spans.get(hierarchy);
                if (span == null) {
                    span = 1;
                }
                context.setColSpan(span);
                context.setHierarchy(hierarchy);
                callback.startCell(context);
                callback.renderCommands(context, this.getCommands(context));
                callback.renderContent(context, this.getLabel(context), this.getValue(context));
                callback.endCell(context);
                context.setColIndex(context.getColumnIndex() + span);
                List properties = (List)propertyMap.get(hierarchy);
                if (properties == null) continue;
                for (Property property : properties) {
                    context.setColSpan(1);
                    context.setColIndex(context.getColumnIndex() + 1);
                    context.setProperty(property);
                    callback.startCell(context);
                    callback.renderCommands(context, this.getCommands(context));
                    callback.renderContent(context, this.getLabel(context), this.getValue(context));
                    callback.endCell(context);
                }
            }
        } else if (renderLevelTitle) {
            final HashMap levels = new HashMap();
            final HashMap properties = new HashMap();
            rowRoot.walkChildren(new TreeNodeCallback<TableAxisContext>(){

                @Override
                public int handleTreeNode(TreeNode<TableAxisContext> node) {
                    TableHeaderNode headerNode = (TableHeaderNode)node;
                    int colIndex = headerNode.getRowIndex() - 1;
                    if (headerNode.getMember() != null && !levels.containsKey(colIndex)) {
                        levels.put(colIndex, headerNode.getMember().getLevel());
                    }
                    if (headerNode.getProperty() != null && !properties.containsKey(colIndex)) {
                        properties.put(colIndex, headerNode.getProperty());
                    }
                    return 0;
                }
            });
            context.setAxis((Axis)Axis.ROWS);
            context.setColSpan(1);
            context.setRowSpan(1);
            context.setCellType("title");
            for (int i = 0; i < context.getRowHeaderCount(); ++i) {
                context.setColIndex(i);
                Level level = (Level)levels.get(i);
                if (level == null) {
                    context.setHierarchy(null);
                    context.setLevel(null);
                } else {
                    context.setHierarchy(level.getHierarchy());
                    context.setLevel(level);
                }
                context.setProperty((Property)properties.get(i));
                callback.startCell(context);
                callback.renderCommands(context, this.getCommands(context));
                callback.renderContent(context, this.getLabel(context), this.getValue(context));
                callback.endCell(context);
            }
        }
        context.setHierarchy(null);
    }

    protected TableHeaderNode createAxisTree(PivotModel model, Axis axis, MemberHierarchyCache cache) {
        List axes = model.getCellSet().getAxes();
        if (axes.size() < 2) {
            return null;
        }
        CellSetAxis cellSetAxis = (CellSetAxis)axes.get(axis.axisOrdinal());
        List positions = cellSetAxis.getPositions();
        if (positions == null || positions.isEmpty()) {
            return null;
        }
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        ArrayList<Aggregator> hierarchyAggregators = new ArrayList<Aggregator>();
        ArrayList<Aggregator> memberAggregators = new ArrayList<Aggregator>();
        HashMap<AggregatorPosition, List<Aggregator>> aggregatorMap = new HashMap<AggregatorPosition, List<Aggregator>>();
        aggregatorMap.put(AggregatorPosition.Grand, aggregators);
        aggregatorMap.put(AggregatorPosition.Hierarchy, hierarchyAggregators);
        aggregatorMap.put(AggregatorPosition.Member, memberAggregators);
        HashMap<Hierarchy, List<Level>> levelsMap = new HashMap<Hierarchy, List<Level>>();
        boolean containsMeasure = false;
        List firstMembers = ((Position)positions.get(0)).getMembers();
        int index = 0;
        for (Member member : firstMembers) {
            if (member instanceof Measure) {
                containsMeasure = true;
                break;
            }
            ++index;
        }
        AggregatorFactory aggregatorFactory = this.getAggregatorFactory();
        List<Object> aggregatorNames = null;
        List<Object> hierarchyAggregatorNames = null;
        List<Object> memberAggregatorNames = null;
        if (!(aggregatorFactory == null || containsMeasure && index != firstMembers.size() - 1)) {
            aggregatorNames = this.getAggregators(axis, AggregatorPosition.Grand);
            hierarchyAggregatorNames = this.getAggregators(axis, AggregatorPosition.Hierarchy);
            memberAggregatorNames = this.getAggregators(axis, AggregatorPosition.Member);
        }
        if (aggregatorNames == null) {
            aggregatorNames = Collections.emptyList();
        }
        if (hierarchyAggregatorNames == null) {
            hierarchyAggregatorNames = Collections.emptyList();
        }
        if (memberAggregatorNames == null) {
            memberAggregatorNames = Collections.emptyList();
        }
        TableAxisContext nodeContext = new TableAxisContext(model.getCube(), axis, hierarchies, levelsMap, aggregatorMap, cache, this);
        TableHeaderNode axisRoot = new TableHeaderNode(nodeContext);
        LinkedHashSet<Measure> grandTotalMeasures = new LinkedHashSet<Measure>();
        LinkedHashSet<Measure> totalMeasures = new LinkedHashSet<Measure>();
        HashMap memberParentMap = new HashMap();
        Position lastPosition = null;
        OlapUtils utils = new OlapUtils(model.getCube());
        utils.setMemberHierarchyCache(cache);
        for (Position position : positions) {
            TableHeaderNode lastChild = null;
            List members = position.getMembers();
            int n = members.size();
            for (int i = n - 1; i >= 0; --i) {
                Member member;
                ArrayList<Level> levels;
                Member member2 = (Member)members.get(i);
                if (member2 instanceof Measure) {
                    Measure measure = (Measure)member2;
                    if (!totalMeasures.contains(measure)) {
                        totalMeasures.add(measure);
                    }
                    if (!grandTotalMeasures.contains(measure)) {
                        grandTotalMeasures.add(measure);
                    }
                } else {
                    member2 = utils.wrapRaggedIfNecessary(member2);
                }
                if (hierarchies.size() < n) {
                    hierarchies.add(0, member2.getHierarchy());
                }
                if ((levels = (ArrayList<Level>)levelsMap.get(member2.getHierarchy())) == null) {
                    levels = new ArrayList<Level>();
                    levelsMap.put(member2.getHierarchy(), levels);
                }
                if (!levels.contains(member2.getLevel())) {
                    levels.add(0, member2.getLevel());
                    Collections.sort(levels, this.levelComparator);
                }
                TableHeaderNode childNode = new TableHeaderNode(nodeContext);
                childNode.setMember(member2);
                childNode.setHierarchy(member2.getHierarchy());
                childNode.setPosition(position);
                if (lastChild != null) {
                    childNode.addChild(lastChild);
                }
                lastChild = childNode;
                if (!hierarchyAggregatorNames.isEmpty() && lastPosition != null) {
                    Member lastMember;
                    int start = n - 1;
                    if (containsMeasure) {
                        --start;
                    }
                    if (i < start && (OlapUtils.equals((MetadataElement)(lastMember = (Member)lastPosition.getMembers().get(i)).getHierarchy(), (MetadataElement)member2.getHierarchy()) && !OlapUtils.equals((MetadataElement)lastMember, (MetadataElement)member2) || !OlapUtils.equals(position, lastPosition, i))) {
                        for (String string : hierarchyAggregatorNames) {
                            this.createAggregators(string, nodeContext, hierarchyAggregators, axisRoot, null, lastPosition.getMembers().subList(0, i + 1), totalMeasures);
                        }
                    }
                }
                if (memberAggregatorNames.isEmpty()) continue;
                ArrayList<AggregationTarget> memberParents = (ArrayList<AggregationTarget>)memberParentMap.get(member2.getHierarchy());
                if (memberParents == null) {
                    memberParents = new ArrayList<AggregationTarget>();
                    memberParentMap.put(member2.getHierarchy(), memberParents);
                }
                AggregationTarget lastSibling = null;
                if (!memberParents.isEmpty()) {
                    lastSibling = (AggregationTarget)memberParents.get(memberParents.size() - 1);
                }
                if ((member = utils.getTopLevelRaggedMember(member2)) != null) {
                    if (lastSibling == null || cache.getAncestorMembers(member).contains(lastSibling.getParent())) {
                        memberParents.add(new AggregationTarget(member, member2.getLevel()));
                    } else if (!OlapUtils.equals((MetadataElement)member, (MetadataElement)lastSibling.getParent())) {
                        int n2;
                        AggregationTarget lastParent;
                        while (!memberParents.isEmpty() && !OlapUtils.equals((MetadataElement)(lastParent = (AggregationTarget)memberParents.get(n2 = memberParents.size() - 1)).getParent(), (MetadataElement)member)) {
                            memberParents.remove(n2);
                            ArrayList<Member> path = new ArrayList<Member>(lastPosition.getMembers().subList(0, i));
                            path.add(lastParent.getParent());
                            Level parentLevel = lastParent.getParent().getLevel();
                            if (!levels.contains(parentLevel)) {
                                levels.add(0, parentLevel);
                                Collections.sort(levels, this.levelComparator);
                            }
                            for (String string : memberAggregatorNames) {
                                this.createAggregators(string, nodeContext, memberAggregators, axisRoot, lastParent.getLevel(), path, totalMeasures);
                            }
                        }
                    }
                }
                if (lastPosition == null || OlapUtils.equals(position, lastPosition, i)) continue;
                Hierarchy hierarchy = nodeContext.getHierarchies().get(i);
                Level rootLevel = nodeContext.getLevels(hierarchy).get(0);
                for (AggregationTarget target : memberParents) {
                    Member memberParent = target.getParent();
                    if (memberParent.getLevel().getDepth() < rootLevel.getDepth()) continue;
                    ArrayList<Member> arrayList = new ArrayList<Member>(lastPosition.getMembers().subList(0, i));
                    arrayList.add(memberParent);
                    for (String string : memberAggregatorNames) {
                        this.createAggregators(string, nodeContext, memberAggregators, axisRoot, target.getLevel(), arrayList, totalMeasures);
                    }
                }
                memberParents.clear();
            }
            if (lastChild != null) {
                axisRoot.addChild(lastChild);
            }
            lastPosition = position;
        }
        if (lastPosition != null) {
            int memberCount = lastPosition.getMembers().size();
            int start = memberCount - 1;
            if (containsMeasure) {
                --start;
            }
            for (int i = start; i >= 0; --i) {
                if (!memberAggregatorNames.isEmpty()) {
                    Hierarchy hierarchy = nodeContext.getHierarchies().get(i);
                    Level level = nodeContext.getLevels(hierarchy).get(0);
                    List memberParents = (List)memberParentMap.get(hierarchy);
                    for (AggregationTarget target : memberParents) {
                        Member member = target.getParent();
                        if (member.getLevel().getDepth() < level.getDepth()) continue;
                        ArrayList<Member> path = new ArrayList<Member>(lastPosition.getMembers().subList(0, i));
                        path.add(member);
                        for (String string : memberAggregatorNames) {
                            this.createAggregators(string, nodeContext, memberAggregators, axisRoot, target.getLevel(), path, totalMeasures);
                        }
                    }
                }
                if (hierarchyAggregatorNames.isEmpty()) continue;
                for (String string : hierarchyAggregatorNames) {
                    this.createAggregators(string, nodeContext, hierarchyAggregators, axisRoot, null, lastPosition.getMembers().subList(0, i), totalMeasures);
                }
            }
            if (!aggregatorNames.isEmpty()) {
                List<Member> members = Collections.emptyList();
                for (String string : aggregatorNames) {
                    this.createAggregators(string, nodeContext, aggregators, axisRoot, null, members, grandTotalMeasures);
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Original axis tree root for {}", (Object)axis);
            axisRoot.walkTree(new TreeNodeCallback<TableAxisContext>(){

                @Override
                public int handleTreeNode(TreeNode<TableAxisContext> node) {
                    String label = node.toString();
                    TableRenderer.this.logger.trace(StringUtils.leftPad((String)label, (int)(node.getLevel() + label.length()), (char)' '));
                    return 0;
                }
            });
        }
        return axisRoot;
    }

    protected List<TableHeaderNode> createFilterAxisTrees(PivotModel model, MemberHierarchyCache cache) {
        ChangeSlicer transform = model.getTransform(ChangeSlicer.class);
        List<Hierarchy> hierarchies = transform.getHierarchies();
        ArrayList<TableHeaderNode> nodes = new ArrayList<TableHeaderNode>(hierarchies.size());
        for (Hierarchy hierarchy : hierarchies) {
            nodes.add(this.createFilterAxisTree(model, hierarchy, cache));
        }
        return nodes;
    }

    protected TableHeaderNode createFilterAxisTree(PivotModel model, Hierarchy hierarchy, MemberHierarchyCache cache) {
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>(1);
        hierarchies.add(hierarchy);
        HashMap<Hierarchy, List<Level>> levelsMap = new HashMap<Hierarchy, List<Level>>(1);
        ArrayList<Level> levels = new ArrayList<Level>(hierarchy.getLevels().size());
        levelsMap.put(hierarchy, levels);
        TableAxisContext nodeContext = new TableAxisContext(model.getCube(), (Axis)Axis.FILTER, hierarchies, levelsMap, null, cache, this);
        TableHeaderNode axisRoot = new TableHeaderNode(nodeContext);
        axisRoot.setHierarchy(hierarchy);
        ChangeSlicer transform = model.getTransform(ChangeSlicer.class);
        List<Member> members = transform.getSlicer(hierarchy);
        MemberSelection selection = new MemberSelection(model.getCube());
        selection.setMemberHierarchyCache(cache);
        selection.addMembers(members);
        for (Member member : selection.getMembers()) {
            TableHeaderNode childNode = new TableHeaderNode(nodeContext);
            childNode.setMember(member);
            childNode.setHierarchy(hierarchy);
            axisRoot.addChild(childNode);
            if (levels.contains(member.getLevel())) continue;
            levels.add(0, member.getLevel());
        }
        Collections.sort(levels, this.levelComparator);
        return axisRoot;
    }

    private void createAggregators(String aggregatorName, TableAxisContext context, List<Aggregator> aggregators, TableHeaderNode axisRoot, Level level, List<Member> members, Set<Measure> measures) {
        AggregatorFactory factory = this.getAggregatorFactory();
        if (measures.isEmpty()) {
            Aggregator aggregator = factory.createAggregator(aggregatorName, context.getAxis(), members, level, null);
            if (aggregator != null) {
                aggregators.add(aggregator);
                TableHeaderNode aggNode = this.createAggregationNode(context, aggregator);
                axisRoot.addChild(aggNode);
            }
        } else {
            for (Measure measure : measures) {
                Aggregator aggregator = factory.createAggregator(aggregatorName, context.getAxis(), members, level, measure);
                if (aggregator == null) continue;
                aggregators.add(aggregator);
                TableHeaderNode aggNode = this.createAggregationNode(context, aggregator);
                axisRoot.addChild(aggNode);
            }
        }
    }

    protected TableHeaderNode createAggregationNode(TableAxisContext nodeContext, Aggregator aggregator) {
        Measure measure;
        TableHeaderNode node;
        TableHeaderNode result = null;
        TableHeaderNode parent = null;
        ArrayList<Member> members = new ArrayList<Member>(aggregator.getMembers());
        AggregatePosition position = new AggregatePosition(members);
        for (Member member : aggregator.getMembers()) {
            node = new TableHeaderNode(nodeContext);
            node.setAggregation(true);
            node.setMember(member);
            node.setPosition(position);
            node.setHierarchy(member.getHierarchy());
            if (result == null) {
                result = node;
            }
            if (parent != null) {
                parent.addChild(node);
            }
            parent = node;
        }
        if (parent != null && aggregator.getLevel() != null && !this.getShowParentMembers()) {
            parent.setAggregator(aggregator);
        }
        int index = Math.min(nodeContext.getHierarchies().size() - 1, members.size());
        Hierarchy hierarchy = aggregator.getLevel() == null ? nodeContext.getHierarchies().get(index) : aggregator.getLevel().getHierarchy();
        if (aggregator.getLevel() == null || this.getShowParentMembers()) {
            node = new TableHeaderNode(nodeContext);
            node.setAggregation(true);
            node.setAggregator(aggregator);
            node.setPosition(position);
            node.setHierarchy(hierarchy);
            if (parent != null) {
                parent.addChild(node);
            }
            if (result == null) {
                result = node;
            }
            parent = node;
        }
        if ((measure = aggregator.getMeasure()) != null) {
            TableHeaderNode measureNode = new TableHeaderNode(nodeContext);
            measureNode.setAggregation(true);
            measureNode.setAggregator(aggregator);
            measureNode.setPosition(position);
            measureNode.setMember((Member)measure);
            measureNode.setHierarchy(measure.getHierarchy());
            parent.addChild(measureNode);
            members.add((Member)measure);
        }
        return result;
    }

    protected void configureAxisTree(PivotModel model, Axis axis, TableHeaderNode node) {
        if (this.getShowDimensionTitle() && axis == Axis.COLUMNS) {
            node.addHierarhcyHeaders();
        }
        if (this.getShowParentMembers() || axis == Axis.FILTER) {
            node.addParentMemberHeaders();
        }
        if (!this.getHideSpans() || axis == Axis.FILTER) {
            node.mergeChildren();
        }
        if (this.getPropertyCollector() != null) {
            node.addMemberProperties();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configured axis tree root for {}", (Object)axis);
            node.walkTree(new TreeNodeCallback<TableAxisContext>(){

                @Override
                public int handleTreeNode(TreeNode<TableAxisContext> node) {
                    String label = node.toString();
                    TableRenderer.this.logger.debug(StringUtils.leftPad((String)label, (int)(node.getLevel() + label.length()), (char)' '));
                    return 0;
                }
            });
        }
    }

    protected void invalidateAxisTree(PivotModel model, Axis axis, TableHeaderNode node) {
        node.walkChildren(new TreeNodeCallback<TableAxisContext>(){

            @Override
            public int handleTreeNode(TreeNode<TableAxisContext> node) {
                TableHeaderNode headerNode = (TableHeaderNode)node;
                headerNode.clearCache();
                return 0;
            }
        });
        ((TableAxisContext)node.getReference()).getRowSpanCache().clear();
    }

    protected void renderFilter(final TableRenderContext context, TableHeaderNode filterRoot, final TableRenderCallback callback) {
        Hierarchy hierarchy = filterRoot.getHierarchy();
        context.setAxis((Axis)Axis.FILTER);
        context.setHierarchy(hierarchy);
        context.setLevel(null);
        context.setMember(null);
        context.setCell(null);
        context.setAggregator(null);
        context.setPosition(null);
        context.setProperty(null);
        callback.startTable(context);
        final HashMap levels = new HashMap();
        filterRoot.walkChildren(new TreeNodeCallback<TableAxisContext>(){

            @Override
            public int handleTreeNode(TreeNode<TableAxisContext> node) {
                TableHeaderNode headerNode = (TableHeaderNode)node;
                levels.put(node.getLevel(), headerNode.getMember().getLevel());
                return 0;
            }
        });
        int rows = levels.size();
        int columns = filterRoot.getWidth() + 1;
        context.setColIndex(0);
        context.setRowIndex(0);
        context.setCellType("title");
        context.setRenderPropertyCategory("title");
        context.setColSpan(columns);
        context.setRowSpan(1);
        callback.startHeader(context);
        callback.startRow(context);
        callback.startCell(context);
        callback.renderContent(context, this.getLabel(context), this.getValue(context));
        callback.endCell(context);
        callback.endRow(context);
        callback.endHeader(context);
        callback.startBody(context);
        for (int rowIndex = 1; rowIndex <= rows; ++rowIndex) {
            context.setCellType("title");
            context.setRenderPropertyCategory("title");
            context.setRowIndex(rowIndex);
            context.setColIndex(1);
            context.setColSpan(1);
            context.setRowSpan(1);
            callback.startRow(context);
            context.setLevel((Level)levels.get(rowIndex));
            callback.startCell(context);
            callback.renderContent(context, this.getLabel(context), this.getValue(context));
            callback.endCell(context);
            context.setCellType("label");
            context.setRenderPropertyCategory("label");
            filterRoot.walkChildrenAtRowIndex(new TreeNodeCallback<TableAxisContext>(){

                @Override
                public int handleTreeNode(TreeNode<TableAxisContext> node) {
                    TableHeaderNode headerNode = (TableHeaderNode)node;
                    context.setColIndex(headerNode.getColIndex() + 1);
                    context.setColSpan(headerNode.getColSpan());
                    context.setRowSpan(headerNode.getRowSpan());
                    context.setLevel(headerNode.getMember().getLevel());
                    context.setMember(headerNode.getMember());
                    callback.startCell(context);
                    callback.renderContent(context, TableRenderer.this.getLabel(context), TableRenderer.this.getValue(context));
                    callback.endCell(context);
                    return 0;
                }
            }, rowIndex);
            callback.endRow(context);
        }
        callback.endBody(context);
        callback.endTable(context);
    }

    static class AggregatePosition
    implements Position {
        private List<Member> members;

        AggregatePosition(List<Member> members) {
            this.members = members;
        }

        public List<Member> getMembers() {
            return this.members;
        }

        public int getOrdinal() {
            return -1;
        }

        public int hashCode() {
            return 31 + this.members.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AggregatePosition other = (AggregatePosition)obj;
            return this.members.equals(other.members);
        }
    }

    static class AggregationTarget {
        private Member parent;
        private Level level;

        AggregationTarget(Member parent, Level level) {
            this.parent = parent;
            this.level = level;
        }

        public Member getParent() {
            return this.parent;
        }

        public Level getLevel() {
            return this.level;
        }
    }
}

